/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.security.canl.SSLContextCreator;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HostnameMismatchCallbackImpl;
import eu.unicore.util.httpclient.IPlainClientConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;

public class AuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger log = Log.getLogger("unicore.security", AuthSSLProtocolSocketFactory.class);
    private SSLContext sslcontext = null;
    private IPlainClientConfiguration sec;

    public AuthSSLProtocolSocketFactory(IPlainClientConfiguration sec) {
        this.sec = sec;
    }

    private synchronized SSLContext createSSLContext() {
        X509Credential credential = this.sec.doSSLAuthn() ? this.sec.getCredential() : null;
        try {
            return SSLContextCreator.createSSLContext(credential, (X509CertChainValidator)this.sec.getValidator(), "TLS", "HTTP Client", log);
        }
        catch (Exception e) {
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            Socket socket = socketfactory.createSocket(host, port, localAddress, localPort);
            this.checkHostname((SSLSocket)socket);
            return socket;
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        socket.setSoTimeout(timeout);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    private void checkHostname(SSLSocket socket) throws IOException {
        HostnameMismatchCallbackImpl callback = new HostnameMismatchCallbackImpl(this.sec.getServerHostnameCheckingMode());
        SocketFactoryCreator.connectWithHostnameChecking((SSLSocket)socket, (HostnameMismatchCallback)callback);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(host, port);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket socket2 = this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        this.checkHostname((SSLSocket)socket2);
        return socket2;
    }
}

