/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.unicore.security.canl.CredentialProperties;
import eu.unicore.security.canl.DefaultAuthnAndTrustConfiguration;
import eu.unicore.security.canl.LoggingStoreUpdateListener;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.FilePropertiesHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AuthnAndTrustProperties
extends DefaultAuthnAndTrustConfiguration {
    private static final Logger log = Log.getLogger("unicore.configuration", AuthnAndTrustProperties.class);
    private TruststoreProperties truststoreProperties;
    private CredentialProperties credentialProperties;

    public AuthnAndTrustProperties(String file) throws IOException, ConfigurationException {
        this(new File(file));
    }

    public AuthnAndTrustProperties(File file) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file));
    }

    public AuthnAndTrustProperties(String file, String trustPrefix, String credPrefix) throws IOException, ConfigurationException {
        this(new File(file), trustPrefix, credPrefix);
    }

    public AuthnAndTrustProperties(File file, String trustPrefix, String credPrefix) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file), trustPrefix, credPrefix, null, false, false);
    }

    public AuthnAndTrustProperties(Properties p) throws ConfigurationException {
        this(p, "truststore.", "credential.", null, false, false);
    }

    public AuthnAndTrustProperties(Properties p, String trustPrefix, String credPrefix) throws ConfigurationException {
        this(p, trustPrefix, credPrefix, null, false, false);
    }

    public AuthnAndTrustProperties(String file, PasswordCallback callback) throws IOException, ConfigurationException {
        this(new File(file), callback);
    }

    public AuthnAndTrustProperties(File file, PasswordCallback callback) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file), callback);
    }

    public AuthnAndTrustProperties(String file, String trustPrefix, String credPrefix, PasswordCallback callback) throws IOException, ConfigurationException {
        this(new File(file), trustPrefix, credPrefix, callback);
    }

    public AuthnAndTrustProperties(File file, String trustPrefix, String credPrefix, PasswordCallback callback) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file), trustPrefix, credPrefix, callback, false, false);
    }

    public AuthnAndTrustProperties(Properties p, PasswordCallback callback) throws ConfigurationException {
        this(p, "truststore.", "credential.", callback, false, false);
    }

    public AuthnAndTrustProperties(Properties p, PasswordCallback callback, String trustPrefix, String credPrefix) throws ConfigurationException {
        this(p, trustPrefix, credPrefix, callback, false, false);
    }

    protected AuthnAndTrustProperties(TruststoreProperties trustProps, CredentialProperties credProps, DefaultAuthnAndTrustConfiguration configured) {
        this.credentialProperties = credProps;
        this.truststoreProperties = trustProps;
        this.setValidator(configured.getValidator());
        this.setCredential(configured.getCredential());
    }

    public AuthnAndTrustProperties(Properties p, String trustPrefix, String credPrefix, boolean trustOptional, boolean credOptional) throws ConfigurationException {
        this(p, trustPrefix, credPrefix, null, trustOptional, credOptional);
    }

    public AuthnAndTrustProperties(Properties p, String trustPrefix, String credPrefix, PasswordCallback passwordCallback, boolean trustOptional, boolean credOptional) throws ConfigurationException {
        try {
            this.truststoreProperties = new TruststoreProperties(p, Collections.singleton(new LoggingStoreUpdateListener()), passwordCallback, trustPrefix);
            this.setValidator(this.truststoreProperties.getValidator());
        }
        catch (ConfigurationException e) {
            if (!trustOptional) {
                throw e;
            }
            log.info((Object)("Trust store settings (optional) were not loaded as: " + e.getMessage()));
        }
        try {
            this.credentialProperties = new CredentialProperties(p, passwordCallback, credPrefix);
            this.setCredential(this.credentialProperties.getCredential());
        }
        catch (ConfigurationException e) {
            if (!credOptional) {
                throw e;
            }
            log.info((Object)("Credential (optional) was not loaded as: " + e.getMessage()));
        }
    }

    public TruststoreProperties getTruststoreProperties() {
        return this.truststoreProperties;
    }

    public CredentialProperties getCredentialProperties() {
        return this.credentialProperties;
    }

    @Override
    public AuthnAndTrustProperties clone() {
        AuthnAndTrustProperties clonedRaw = (AuthnAndTrustProperties)super.clone();
        CredentialProperties cp = this.credentialProperties == null ? null : this.credentialProperties.clone();
        TruststoreProperties tp = this.truststoreProperties == null ? null : this.truststoreProperties.clone();
        clonedRaw.credentialProperties = cp;
        clonedRaw.truststoreProperties = tp;
        return clonedRaw;
    }
}

