/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.api;

import java.util.List;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.ApplicationActions;
import pl.edu.icm.unicore.uvos.api.ApplicationStatus;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.api.exceptions.VOApplicationException;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSApplicationsInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsclient.api.VOApplicationExtInterface;
import xmlbeans.pl.edu.icm.uvos.internal.app.ProcessActionType;
import xmlbeans.pl.edu.icm.uvos.internal.app.ProcessVOApplicationDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.ProcessVOApplicationType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationListDocument;

public class WSApplicationClient
implements VOApplicationExtInterface {
    private WSApplicationsInterface proxy;

    public WSApplicationClient(WSApplicationsInterface proxy) {
        this.proxy = proxy;
    }

    @Override
    public List<VOApplicationForm> getApplicationForms() throws UVOSException {
        try {
            return XMLBeansMapper.map2APIVOApplicationFormList((VOApplicationFormListDocument)this.proxy.getApplicationForms());
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeApplicationForm(int id) throws UVOSException {
        try {
            this.proxy.removeApplicationForm(id);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void updateApplicationForm(VOApplicationForm applicationDef, boolean update) throws UVOSException {
        try {
            this.proxy.updateApplicationForm(XMLBeansMapper.map2XMLVOApplicationFormDoc((VOApplicationForm)applicationDef), update);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
        catch (XmlException e) {
            throw new VOApplicationException("Can't parse applicationform constraints: " + (Object)((Object)e));
        }
    }

    @Override
    public List<VOApplication> getApplications(Integer formId, ApplicationStatus status) throws UVOSException {
        try {
            VOApplicationListDocument list = this.proxy.getApplications(formId, status == null ? null : status.toString());
            return XMLBeansMapper.map2APIVOApplicationList((VOApplicationListDocument)list);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void submitApplication(VOApplication application) throws UVOSException {
        try {
            this.proxy.submitApplication(XMLBeansMapper.map2XMLVOApplicationDoc((VOApplication)application));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
        catch (XmlException e) {
            throw new VOApplicationException("Can't parse application's requirements: " + (Object)((Object)e));
        }
    }

    @Override
    public void processApplication(int id, ApplicationActions action, String notes, boolean sendConfirmation, VOApplication application) throws UVOSException {
        try {
            ProcessVOApplicationDocument reqDoc = ProcessVOApplicationDocument.Factory.newInstance();
            ProcessVOApplicationType req = reqDoc.addNewProcessVOApplication();
            req.setAction(ProcessActionType.Enum.forString((String)action.toString()));
            req.setApplicationId(id);
            if (notes != null) {
                req.setNotes(notes);
            }
            req.setSendConfirmation(sendConfirmation);
            if (application != null) {
                req.setUpdatedApplication(XMLBeansMapper.map2XMLVOApplication((VOApplication)application));
            }
            this.proxy.processApplication(reqDoc);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
        catch (XmlException e) {
            throw new VOApplicationException("Can't parse application's requirements: " + (Object)((Object)e));
        }
    }

    @Override
    public void csrProcessedNotification(String csr, boolean accepted, String certificate, boolean sendNotification) throws UVOSException {
        try {
            this.proxy.csrProcessedNotification(csr, accepted, certificate, sendNotification);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }
}

