/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.client.util;

import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class UVOSClientProperties
extends ClientProperties {
    @DocumentationReferencePrefix
    public static final String PREFIX = "uvos.";
    private static final Logger log = Log.getLogger((String)"unicore.configuration", UVOSClientProperties.class);
    public static final String PROP_SERVER_HOST = "host";
    public static final String PROP_SERVER_PORT = "port";
    public static final String PROP_SERVER_PROTOCOL = "protocol";
    public static final String PROP_SERVICE_PATH = "servicePath";
    public static final String PROP_ETD = "etdFile";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();
    protected String host;
    protected int port;
    protected String protocol;
    protected String servicePath;
    protected File etdPath;

    public UVOSClientProperties(String file) throws ConfigurationException, IOException {
        this(FilePropertiesHelper.load((String)file));
    }

    public UVOSClientProperties(Properties source) throws ConfigurationException, IOException {
        super(source);
        PropertiesHelper properties = new PropertiesHelper(PREFIX, source, DEFAULTS, log);
        this.host = properties.getValue(PROP_SERVER_HOST);
        this.port = properties.getIntValue(PROP_SERVER_PORT);
        this.protocol = properties.getValue(PROP_SERVER_PROTOCOL);
        this.servicePath = properties.getValue(PROP_SERVICE_PATH);
        this.setEtdPath(properties.getFileValue(PROP_ETD, false));
    }

    protected UVOSClientProperties() {
    }

    public int getServerPort() {
        return this.port;
    }

    public String getServerHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getServicePath() {
        return this.protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public File getEtdPath() {
        return this.etdPath;
    }

    public void setEtdPath(File etdPath) throws IOException {
        this.etdPath = etdPath;
        if (etdPath == null) {
            return;
        }
        List<TrustDelegation> tdTokens = this.getTDTokens(etdPath);
        this.getETDSettings().setTrustDelegationTokens(tdTokens);
    }

    protected List<TrustDelegation> getTDTokens(File tdFile) throws IOException {
        try {
            AssertionDocument td = AssertionDocument.Factory.parse((File)tdFile);
            ArrayList<TrustDelegation> res = new ArrayList<TrustDelegation>();
            res.add(new TrustDelegation(td));
            return res;
        }
        catch (Exception xe) {
            IOException e = new IOException("Attempted to create trust delegation token from invalid XML.");
            e.initCause(xe);
            throw e;
        }
    }

    public UVOSClientProperties clone() {
        UVOSClientProperties ret = new UVOSClientProperties();
        this.cloneTo((DefaultClientConfiguration)ret);
        ret.setServicePath(this.servicePath);
        ret.setProtocol(this.protocol);
        ret.setHost(this.host);
        ret.setPort(this.port);
        ret.etdPath = this.etdPath;
        ret.getETDSettings().setTrustDelegationTokens(this.getETDSettings().getTrustDelegationTokens());
        return ret;
    }

    static {
        PropertyMD.DocumentationCategory main = new PropertyMD.DocumentationCategory("Main", "a");
        PropertyMD.DocumentationCategory extra = new PropertyMD.DocumentationCategory("Additional", "b");
        DEFAULTS.put(PROP_SERVER_HOST, new PropertyMD("localhost").setCategory(main).setDescription("UVOS server host"));
        DEFAULTS.put(PROP_SERVER_PORT, new PropertyMD("2443").setBounds(1L, 65535L).setCategory(main).setDescription("UVOS server port"));
        DEFAULTS.put(PROP_SERVER_PROTOCOL, new PropertyMD("https").setCategory(main).setDescription("Protocol to use. 'http' or (in the most cases) 'https'."));
        DEFAULTS.put(PROP_SERVICE_PATH, new PropertyMD("").setCategory(extra).setDescription("Service path. For UVOS it should be left empty, for other implementations its deployment path should be given."));
        DEFAULTS.put(PROP_ETD, new PropertyMD().setPath().setCategory(extra).setDescription("Optional path of a file with a trust delegation which should be used."));
        for (String key : ClientProperties.META.keySet()) {
            DEFAULTS.put(key, ((PropertyMD)ClientProperties.META.get(key)).clone().setCategory(extra));
        }
    }
}

