/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.io.FileInputStream;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class UpdateCSRApplicationAction
extends AbstractAction {
    UpdateCSRApplicationAction(ConnectionManager cm) {
        super(cm, "updateCSRApplication", "Updates an application containing CSR only, when CSR is processed (i.e. accpted or rejected) by a CA. \nSyntax:\n   updateCSRApplication <fileWithCSR> <accepted:true|false> <sendEmail:true|false> [<fileWithSignedCert>]\nFile with signed certificate is needed if accepted is true.", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        String csr;
        boolean sendConfirm = false;
        boolean accepted = false;
        try {
            csr = this.readFile(args[1], "CSR");
            if (csr == null) {
                return true;
            }
            csr = csr.trim();
            accepted = "true".equalsIgnoreCase(args[2]);
            sendConfirm = "true".equalsIgnoreCase(args[3]);
        }
        catch (IllegalArgumentException e) {
            throw new InternalException(args[2] + " is invalid.");
        }
        String certificate = null;
        if (args.length > 4) {
            certificate = this.readFile(args[4], "certificate");
            if (certificate == null) {
                return true;
            }
            certificate = certificate.trim();
        } else if (accepted) {
            System.out.println("You must specify a file with certificate when the CSR is accepted.");
            return true;
        }
        this.cm.voApps.csrProcessedNotification(csr, accepted, certificate, sendConfirm);
        System.out.println("VO application CSR was updated successfuly");
        return true;
    }

    private String readFile(String name, String type) {
        try {
            FileInputStream fis = new FileInputStream(name);
            byte[] tmp = new byte[20480];
            if (fis.read(tmp) < 0) {
                System.out.println("Can't read a file with " + type + ".");
                return null;
            }
            return new String(tmp);
        }
        catch (Exception e) {
            System.out.println("Can't read a file with " + type + ": " + e);
            return null;
        }
    }
}

