/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class SetAuthZAction
extends AbstractAction {
    SetAuthZAction(ConnectionManager cm) {
        super(cm, "setAuthz", "Modifies authorization policy for VO service access\nSyntax:\n   setAuthz <group> a <perm> <AttributeName> [value]]\n   setAuthz <group> <o|m> <perm>\nUse group '/' to modify global policy. Permissions can assigned either to the bearer of attribute or to the accessed resource owner ('o' case) or to the group members ('m' case')\nIn any case permissions are specified as string with syntax:\n   <r|-><f|-><i|-><w|->\nwhere 'r' is read permission, 'f' is full read permission, 'i' is identityCtl permission and 'w' is write permission.\nExample:\n  setAuthz /some/group m -f---\nIt will assign members of /some/group (and it's subgroups) the fullRead permission and remove all other permissions (if were set).", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        PermissionDesignator designator;
        if (args[2].equals("a")) {
            if (args.length < 5) {
                System.out.println("Not enough arguments");
                return true;
            }
            Attribute a = this.getAttribute(args[4], args, 5, args.length);
            designator = new PermissionDesignator(a);
        } else if (args[2].equals("o")) {
            designator = new PermissionDesignator(PermissionDesignator.SpecialDesignator.OWNER);
        } else if (args[2].equals("m")) {
            designator = new PermissionDesignator(PermissionDesignator.SpecialDesignator.MEMBER);
        } else {
            System.out.println("Wrong type specified (must be 'a', 'm' or 'o')");
            return true;
        }
        Permissions p = this.parsePerm(args[3]);
        if (p == null) {
            return true;
        }
        Group g = null;
        if (!args[1].equals("/")) {
            g = new Group(args[1]);
        }
        this.cm.voAuthz.modifyPermissions(g, designator, p);
        return true;
    }

    private Permissions parsePerm(String arg) {
        char[] c = arg.toCharArray();
        if (c.length != 4) {
            System.out.println("Permissions specification '" + arg + "' is invalid");
            return null;
        }
        int v = 0;
        if (c[0] == 'r') {
            ++v;
        } else if (c[0] != '-') {
            System.out.println("Permissions specification '" + arg + "' is invalid");
            return null;
        }
        if (c[1] == 'f') {
            v += 2;
        } else if (c[1] != '-') {
            System.out.println("Permissions specification '" + arg + "' is invalid");
            return null;
        }
        if (c[2] == 'i') {
            v += 4;
        } else if (c[2] != '-') {
            System.out.println("Permissions specification '" + arg + "' is invalid");
            return null;
        }
        if (c[3] == 'w') {
            v += 8;
        } else if (c[3] != '-') {
            System.out.println("Permissions specification '" + arg + "' is invalid");
            return null;
        }
        return new Permissions(v);
    }
}

