/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class SetAttributeAction
extends AbstractAction {
    SetAttributeAction(ConnectionManager cm) {
        super(cm, "setAttribute", "Adds or changes an attribute. Syntax:\n  setAttribute <global> <dn|x509|email> <identity> <true|false> <attributeTypeAndNameAttributeName> [value1 value2 ...]\n  setAttribute <group> <groupPath> <true|false> <AttributeName> [value1 value2 ...]\n  setAttribute <ig> <dn|x509|email> <identity> <groupPath> <true|false> <AttributeName> [value1 value2 ...]\nThe first argument specifies what kind of attribute will be changed: group attribute, identity global attribute, or identity attribute valid only in particular group. The boolean argument specifies if existing attribute with the same name should be updated.\nExample:\n  setAttribute ig email ann@example.com /group true urn:unicore:attrType:user:proffession scientist\n", 4);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        int next = 3;
        if (e.getIdentity() != null) {
            ++next;
            if (e.getGroup() != null) {
                ++next;
            }
        }
        if (next + 1 >= args.length) {
            System.out.println("Not enough arguments.");
            return true;
        }
        boolean update = Boolean.parseBoolean(args[next]);
        Attribute a = this.getAttribute(args[next + 1], args, next + 2, args.length);
        this.cm.voMan.setAttribute(e, a, update);
        System.out.println("Changed element " + e + " attribute: " + a.getName());
        return true;
    }
}

