/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class ListDisabledAttributesAction
extends AbstractAction {
    ListDisabledAttributesAction(ConnectionManager cm) {
        super(cm, "getDisabledAttributes", "Lists all disabled attributes. Only disabled values are presented. Syntax:\n   getDisabledAttributes <global> <dn|x509|email> <identity>\n   getDisabledAttributes <group> <groupPath>\n   getDisabledAttributes <ig> <dn|x509|email> <identity> <groupPath>\nThe first argument specifies what kind of attribute will be listed: group attribute, identity global attribute, or identity attribute valid only in particular group.\nExample:\n  getDisabledAttributes ig email ann@example.com /group\n", 2, "listDisabledAttributes");
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        List<Attribute> list = this.cm.voMan.getDisabledAttributes(e);
        System.out.println("Disabled attributes are:\n");
        for (Attribute a : list) {
            System.out.println("  " + a);
        }
        return true;
    }
}

