/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetPermissionsAction
extends AbstractAction {
    GetPermissionsAction(ConnectionManager cm) {
        super(cm, "getPerms", "Lists all permissions of specified user\nSyntax:\n   getPerms global <dn|x509|email> <identity>\n   getPerms group <group> <dn|x509|email> <identity>\nExample:\n  getPerms group /some/group email ann@example.com", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        if (args[1].equals("global")) {
            Identity ident = this.getIdentity(args[2], args[3], null);
            if (ident == null) {
                return true;
            }
            Permissions res = this.cm.voAuthz.checkPermissions(null, ident);
            System.out.println("Global permissions: " + res);
        } else if (args[1].equals("group")) {
            if (args.length < 5) {
                System.out.println("Not enough arguments");
                return true;
            }
            Group g = new Group(args[2]);
            Identity ident = this.getIdentity(args[3], args[4], null);
            if (ident == null) {
                return true;
            }
            System.out.println("Permissions in group " + g + ": ");
            Permissions res = this.cm.voAuthz.checkPermissions(g, ident);
            System.out.println(res);
        } else {
            System.out.println("Wrong 1st argument");
        }
        return true;
    }
}

