/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.AttributePermission;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetAuthZAction
extends AbstractAction {
    GetAuthZAction(ConnectionManager cm) {
        super(cm, "getAuthz", "Lists authorization policy for VO service access\nSyntax:\n   getAuthz global\n   getAuthz group <group>\nExample:\n  getAuthz group /some/group m", 1);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        if (args[1].equals("global")) {
            List<AttributePermission> res = this.cm.voAuthz.getGroupAuthZ(null, false);
            System.out.println("Global authorization policy:");
            for (AttributePermission ap : res) {
                System.out.println(ap);
            }
        } else if (args[1].equals("group")) {
            if (args.length < 3) {
                System.out.println("Not enough arguments");
                return true;
            }
            Group g = new Group(args[2]);
            System.out.println(g + " authorization policy:");
            List<AttributePermission> res = this.cm.voAuthz.getGroupAuthZ(g, false);
            for (AttributePermission ap : res) {
                System.out.println(ap);
            }
            System.out.println("\n" + g + " effective authorization policy:");
            List<AttributePermission> res2 = this.cm.voAuthz.getGroupAuthZ(g, true);
            for (AttributePermission ap : res2) {
                System.out.println(ap);
            }
        } else {
            System.out.println("Wrong 1st argument");
        }
        return true;
    }
}

