/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetAttributeAction
extends AbstractAction {
    GetAttributeAction(ConnectionManager cm) {
        super(cm, "getAttribute", "Returns value(s) of the attribute of the given element.\nSyntax:\n   getAttribute <global> <dn|x509|email> <identity> <attribute> [allScopes] [includeImpliedGroups]\n   getAttribute <group> <groupPath> <attribute>\n   getAttribute <ig> <dn|x509|email> <identity> <groupPath> <attribute>\nThe first argument specifies what kind of attribute will be listed: group attribute, identity global attribute, or identity attribute valid only in particular group.\nExample:\n  getAttribute ig email ann@example.com /group urn:unicore:attrType:user:proffession\n", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        int next = 3;
        if (e.getIdentity() != null) {
            ++next;
            if (e.getGroup() != null) {
                ++next;
            }
        }
        if (next >= args.length) {
            System.out.println("Not enough arguments.");
            return true;
        }
        String attr = args[next];
        boolean scopes = false;
        boolean implied = false;
        if (next < args.length) {
            scopes = Boolean.parseBoolean(args[next++]);
        }
        if (next < args.length) {
            implied = Boolean.parseBoolean(args[next++]);
        }
        System.out.println("Effective attributes are: ");
        List<Attribute> ret = this.cm.qTime == null ? this.cm.voQuery.getAttributes(e, attr, true, scopes, implied) : this.cm.voQueryHistory.getAttributes(e, attr, true, scopes, implied, this.cm.qTime);
        for (Attribute a : ret) {
            System.out.println(a.getName());
        }
        System.out.println("Exact attributes are: ");
        List<Attribute> ret2 = this.cm.qTime == null ? this.cm.voQuery.getAttributes(e, attr, false, scopes, implied) : this.cm.voQueryHistory.getAttributes(e, attr, false, scopes, implied, this.cm.qTime);
        for (Attribute a : ret2) {
            System.out.println(a);
        }
        return true;
    }
}

