/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class AddIdentityWithEquivAction
extends AbstractAction {
    AddIdentityWithEquivAction(ConnectionManager cm) {
        super(cm, "addEquivalentIdentity", "Creates a new identity, which is alias of (is equivalent to) another, existing identity. Syntax:\n  addEquivalentIdentity <dn|x509|email> <newIdentity> <dn|x509|email> <equivalent>\nThe first argument is an identity type. Next is value, which is a simple string in case of 'dn' or 'email' types and a file name with X509 certificate in case of 'x509' type. It is the value of added identity. Next come parameters of eqivalent identity. Note that label of the new identity will be the same as of it's eqivalent\nExample:\n  addEquivalentIdentity email john@example.com email john@example.org\n", 4);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity newId = this.getIdentity(args[1], args[2], null);
        if (newId == null) {
            return true;
        }
        Identity equivId = this.getIdentity(args[3], args[4], null);
        if (equivId == null) {
            return true;
        }
        this.cm.voMan.addIdentity(newId, equivId);
        System.out.println("Added identity: " + newId + " equivalent to " + equivId);
        return true;
    }
}

