/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.unicore.util;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.unicore.EMIRegistryAddClient;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Utils {
    private static final Logger logger = Log.getLogger((String)"EMIR-UNICORE", Utils.class);
    private static final StringBuilder query = new StringBuilder();

    public static JSONObject toEmirJSON(EndpointReferenceType eprT, Calendar tt) {
        JSONObject jo = new JSONObject();
        EndpointReferenceType eprt = eprT;
        String serviceUrl = eprt.getAddress().getStringValue();
        QName iName = WSUtilities.extractInterfaceName((EndpointReferenceType)eprt);
        try {
            jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), (Object)serviceUrl);
            jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), (Object)iName.getLocalPart());
            jo.put(ServiceBasicAttributeNames.SERVICE_NAME.getAttributeName(), (Object)iName.getLocalPart());
            try {
                jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)("urn:unicore:" + serviceUrl));
            }
            catch (Exception e) {
                jo.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)UUID.randomUUID());
            }
            String specVersion = Registry.class.getPackage().getSpecificationVersion();
            String implVersion = Registry.class.getPackage().getImplementationVersion();
            if (specVersion != null) {
                jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName(), (Object)specVersion);
            }
            if (implVersion != null) {
                jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPL_VERSION.getAttributeName(), (Object)implVersion);
            }
            try {
                jo.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)("urn:unicore:" + serviceUrl));
            }
            catch (Exception e) {
                jo.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)UUID.randomUUID());
            }
            jo.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)"eu.unicore.USE");
            jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName(), (Object)"webservice");
            String jsonCapabilities = EMIRegistryAddClient.getServiceCapabilities(iName);
            jo.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)new JSONArray(jsonCapabilities));
            jo = tt != null ? DateUtil.addDate((JSONObject)jo, (String)ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), (Date)tt.getTime()) : DateUtil.setExpiryTime((JSONObject)jo, (Integer)1);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Publishing to EMIR: " + jo.toString(2)));
            }
        }
        catch (JSONException e) {
            Log.logException((String)"Error creating JSON document", (Throwable)e, (Logger)logger);
        }
        return jo;
    }

    public static JSONObject toEmirJSON(EndpointReferenceType eprT) {
        return Utils.toEmirJSON(eprT, null);
    }

    public static ServiceT toGlue2Service(ContentType content) {
        XmlObject[] x = content.execQuery(query.toString());
        if (x.length <= 0) {
            return null;
        }
        try {
            String s = x[0].toString();
            ServiceDocument sd = ServiceDocument.Factory.parse((String)s);
            return sd.getService();
        }
        catch (Exception e) {
            Log.logException((String)"Error extracting GLUE2 service from entry content", (Throwable)e);
            return null;
        }
    }

    public static boolean hasNextPageReference(JSONArray jsonArr) throws JSONException {
        JSONObject ref;
        return jsonArr.length() > 0 && !(ref = jsonArr.getJSONObject(jsonArr.length() - 1)).isNull("ref");
    }

    static {
        query.append("declare namespace spec='" + ServiceT.type.getName().getNamespaceURI() + "';");
        query.append("declare namespace sg='" + ContentType.type.getName().getNamespaceURI() + "';");
        query.append("//spec:Service");
    }
}

