/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.unicore;

import de.fzj.unicore.wsrflite.AbstractStartupTask;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.ThreadingServices;
import eu.emi.emir.unicore.EMIRegistryPublisher;
import eu.unicore.util.Log;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class PublishingOnStartup
extends AbstractStartupTask {
    private static final Logger logger = Log.getLogger((String)"EMIR-UNICORE", PublishingOnStartup.class);
    public static final String EMIREGISTRY_PUBLISHING_INTERVAL = "emiregistry.publishing.interval";
    public static final String EMIREGISTRY_PUBLISHING_ENABLE = "emiregistry.publishing.enable";
    public static final String EMIREGISTRY_SERVER_URL = "emiregistry.server.url";
    private Properties props;

    public void run() {
        ContainerProperties cp = this.getKernel().getContainerProperties();
        this.props = cp.getRawProperties();
        Boolean isEnabled = new Boolean(this.props.getProperty(EMIREGISTRY_PUBLISHING_ENABLE, "false"));
        if (isEnabled.booleanValue()) {
            try {
                this.startPublishing();
            }
            catch (Exception ex) {
                logger.error((Object)"Can't initiate publishing to EMIR", (Throwable)ex);
            }
        }
    }

    private void startPublishing() throws Exception {
        String url = this.props.getProperty(EMIREGISTRY_SERVER_URL);
        logger.info((Object)("Start publishing to EMIR server on: " + url));
        Long interval = Long.parseLong(this.props.getProperty(EMIREGISTRY_PUBLISHING_INTERVAL, "5"));
        ThreadingServices ts = this.getKernel().getContainerProperties().getThreadingServices();
        ts.getScheduledExecutorService().scheduleWithFixedDelay(new EMIRegistryPublisher(url, this.getKernel()), 1L, interval, TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("publishing entries to the EMIR server [" + url + "] every " + interval + " seconds"));
        }
    }
}

