/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.unicore;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.emi.emir.client.glue2.XmlbeansToJson;
import eu.emi.emir.unicore.EMIRegistryAddClient;
import eu.emi.emir.unicore.util.Utils;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.jettison.json.JSONArray;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.oasisOpen.docs.wsrf.sg2.ServiceGroupRPDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class EMIRegistryPublisher
implements Runnable {
    private static final Logger logger = Logger.getLogger(EMIRegistryPublisher.class);
    private final EMIRegistryAddClient client;
    private final Kernel kernel;
    public static final String UNICOREX_SERVICE_TYPE = "eu.unicore.USE";

    public EMIRegistryPublisher(String emirUrl, Kernel kernel) throws Exception {
        this.kernel = kernel;
        USEClientProperties csp = kernel.getClientConfiguration();
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(emirUrl);
        this.client = csp.isSslEnabled() ? new EMIRegistryAddClient(epr, (IClientConfiguration)csp) : new EMIRegistryAddClient(epr);
    }

    @Override
    public void run() {
        this.publish();
    }

    private void publish() {
        Home regHome = this.kernel.getHome("Registry");
        JSONArray ja = new JSONArray();
        try {
            Registry reg = (Registry)regHome.get("default_registry");
            GetResourcePropertyDocumentDocument1 d = GetResourcePropertyDocumentDocument1.Factory.newInstance();
            ServiceGroupRPDocument.ServiceGroupRP rp = ServiceGroupRPDocument.ServiceGroupRP.Factory.newInstance();
            rp.set((XmlObject)reg.GetResourcePropertyDocument(d).getGetResourcePropertyDocumentResponse());
            ServiceGroupRPDocument rpDoc = ServiceGroupRPDocument.Factory.parse((String)reg.GetResourcePropertyDocument(d).getGetResourcePropertyDocumentResponse().toString());
            EntryType[] et = rpDoc.getServiceGroupRP().getEntryArray();
            for (int i = 0; i < et.length; ++i) {
                String resourceId = WSServerUtilities.extractResourceID((EndpointReferenceType)et[i].getServiceGroupEntryEPR());
                Home seHome = this.kernel.getHome("ServiceGroupEntry");
                Calendar tt = seHome.get(resourceId).getTerminationTime();
                ContentType content = et[i].getContent();
                ServiceT s = Utils.toGlue2Service(content);
                if (s != null) {
                    ja.put((Object)XmlbeansToJson.convert((ServiceT)s).getJSONObject(0));
                    continue;
                }
                ja.put((Object)Utils.toEmirJSON(et[i].getMemberServiceEPR(), tt));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("publishing to emir: " + rpDoc));
            }
            this.client.addRegistryEntry(ja);
        }
        catch (Exception e) {
            Log.logException((String)"Error publishing local registry entries to EMIR", (Throwable)e);
        }
    }
}

