/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.unicore;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.fzj.unicore.uas.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.client.Resources;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.unicore.util.Utils;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class EMIRegistryClient
implements IRegistryQuery {
    private static final Logger logger = Log.getLogger((String)"EMIR-UCC", EMIRegistryClient.class);
    private String connectionStatus = null;
    private final String url;
    private final IClientConfiguration sProps;
    private final EMIRClient client;
    private final WebResource clientRes;

    public EMIRegistryClient(EndpointReferenceType epr, IClientConfiguration securityConfig) {
        if (securityConfig == null) {
            NullPointerException npe = new NullPointerException();
            Log.logException((String)"Failed to instantiate EMIRegistryClient: Security configuration cannot be NULL", (Throwable)npe);
            throw npe;
        }
        this.sProps = securityConfig;
        this.url = epr.getAddress().getStringValue();
        this.client = new EMIRClient(this.url, securityConfig);
        this.clientRes = this.client.getClientResource();
    }

    public EMIRegistryClient(EndpointReferenceType epr) {
        this.url = epr.getAddress().getStringValue();
        this.client = new EMIRClient(this.url);
        this.clientRes = this.client.getClientResource();
        this.sProps = null;
    }

    public List<EndpointReferenceType> listServices(QName porttype) {
        WebResource q = this.clientRes.path("/services");
        JSONArray ja = (JSONArray)q.queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), porttype.getLocalPart()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
        ArrayList<EndpointReferenceType> lst = new ArrayList<EndpointReferenceType>();
        try {
            int size = ja.length();
            if (size == 0) {
                return lst;
            }
            size = Utils.hasNextPageReference(ja) ? ja.length() - 1 : ja.length();
            for (int i = 0; i < size; ++i) {
                EndpointReferenceType et = EndpointReferenceType.Factory.newInstance();
                JSONObject j = ja.getJSONObject(i);
                et.addNewAddress().setStringValue(j.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()));
                String dn = j.getString(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName());
                WSUtilities.addServerIdentity((EndpointReferenceType)et, (String)dn);
                WSUtilities.addPortType((EndpointReferenceType)et, (QName)porttype);
                lst.add(et);
            }
        }
        catch (Exception e) {
            Log.logException((String)"Error listing services from EMIR", (Throwable)e, (Logger)logger);
        }
        return lst;
    }

    public List<EndpointReferenceType> listServices(QName porttype, IRegistryQuery.ServiceListFilter acceptFilter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<EndpointReferenceType> listAccessibleServices(QName porttype) throws Exception {
        List<EndpointReferenceType> lstAll = this.listServices(porttype);
        ArrayList<EndpointReferenceType> lstAcc = new ArrayList<EndpointReferenceType>();
        try {
            for (EndpointReferenceType eprt : lstAll) {
                BaseWSRFClient c = new BaseWSRFClient(eprt.getAddress().getStringValue(), eprt, this.sProps);
                c.getCurrentTime();
                lstAcc.add(eprt);
            }
        }
        catch (Exception e) {
            Log.logException((String)"Error listing accessible services from EMIR", (Throwable)e, (Logger)logger);
        }
        return lstAcc;
    }

    public List<EntryType> listEntries() throws Exception {
        throw new UnsupportedOperationException();
    }

    public String getConnectionStatus() throws ClientException {
        try {
            this.checkConnection();
        }
        catch (ClientException e) {
            logger.warn((Object)"EMIR connection failed");
        }
        return this.connectionStatus;
    }

    public boolean checkConnection() throws ClientException {
        boolean conn = false;
        try {
            conn = this.checkConnection(2000);
        }
        catch (ClientException e) {
            logger.warn((Object)"EMIR connection failed");
        }
        return conn;
    }

    public boolean checkConnection(int timeout) throws ClientException {
        boolean currentOK;
        StringBuffer status = new StringBuffer();
        boolean result = false;
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((ClientResponse)EMIRegistryClient.this.clientRes.path("/ping").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class)).getStatus() == 200;
            }
        };
        Boolean res = this.compute(task, timeout);
        boolean bl = currentOK = res != null ? res : false;
        if (!currentOK) {
            status.append("[NOT AVAILABLE: ").append(this.url);
            status.append("] ");
        }
        result = result || currentOK;
        this.connectionStatus = result ? "OK" : status.toString();
        return result;
    }

    private Boolean compute(Callable<Boolean> task, int timeout) {
        try {
            Future<Boolean> f = Resources.getExecutorService().submit(task);
            return f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
    }
}

