/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.security.OperationType;
import eu.unicore.security.SEIOperationType;
import eu.unicore.security.xfireutil.OperationsRequiringSignature;
import eu.unicore.security.xfireutil.RequiresSignature;
import eu.unicore.security.xfireutil.client.Configurable;
import eu.unicore.security.xfireutil.client.ContextDSigDecider;
import eu.unicore.security.xfireutil.client.DSigOutHandler;
import eu.unicore.security.xfireutil.client.ExtendedTDOutHandler;
import eu.unicore.security.xfireutil.client.JSR181ServiceFactory;
import eu.unicore.security.xfireutil.client.XFireClientFactory;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jws.WebMethod;
import org.apache.log4j.Logger;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.ServiceFactory;

public class UnicoreXFireClientFactory
extends XFireClientFactory {
    private static final Logger logger = Log.getLogger((String)"unicore.client", UnicoreXFireClientFactory.class);
    protected final IClientConfiguration security;
    private ContextDSigDecider decider;

    public UnicoreXFireClientFactory() {
        this((IClientConfiguration)new DefaultClientConfiguration());
    }

    public UnicoreXFireClientFactory(IClientConfiguration sec) {
        this((ServiceFactory)new JSR181ServiceFactory(), sec);
    }

    public UnicoreXFireClientFactory(ServiceFactory serviceFactory, IClientConfiguration sec) {
        super(serviceFactory, sec);
        this.security = this.securityProperties;
    }

    @Override
    protected void initHandlers() {
        super.initHandlers();
        this.decider = new ContextDSigDecider();
        IClientConfiguration security = this.securityProperties;
        this.addHandlers(this.outHandlers, security.getOutHandlerClassNames());
        if (security.doSignMessage()) {
            this.outHandlers.add(new DSigOutHandler(security.getCredential(), this.decider));
        }
        if (security.getETDSettings() != null) {
            this.outHandlers.add(new ExtendedTDOutHandler(security));
        }
        this.addHandlers(this.inHandlers, security.getInHandlerClassNames());
    }

    private Class<? extends Handler> loadClass(String name) throws ClassNotFoundException {
        IClientConfiguration security = this.securityProperties;
        if (security.getClassLoader() != null) {
            return Class.forName(name, true, security.getClassLoader());
        }
        return Class.forName(name);
    }

    private void addHandlers(List<Handler> list, String[] handlers) {
        if (handlers == null) {
            return;
        }
        for (String className : handlers) {
            if (className == null || className.length() == 0) continue;
            try {
                Class<? extends Handler> clazz = this.loadClass(className);
                Handler h = clazz.newInstance();
                if (h instanceof Configurable) {
                    ((Configurable)h).configure(this.securityProperties);
                }
                list.add(h);
                logger.debug((Object)("Sucessfully added security handler <" + className + ">"));
            }
            catch (Exception e) {
                logger.error((Object)("Could not setup security handler <" + className + "!"), (Throwable)e);
            }
        }
    }

    @Override
    protected <T> void setupProxyInterface(Class<T> iFace, Client xfireClient, IClientConfiguration cnf, Properties properties) {
        xfireClient.setProperty(ContextDSigDecider.SIGNED_OPERATIONS, UnicoreXFireClientFactory.getOperationsToSign(iFace));
    }

    public static <T> Set<String> getOperationsToSign(Class<T> iFace) {
        Method[] methods;
        HashSet<String> opsToSign = new HashSet<String>();
        OperationsRequiringSignature list = iFace.getAnnotation(OperationsRequiringSignature.class);
        if (list != null) {
            for (String s : list.operations()) {
                opsToSign.add(s);
            }
        }
        for (Method m : methods = iFace.getMethods()) {
            if (m.getAnnotation(RequiresSignature.class) == null) continue;
            WebMethod wm = m.getAnnotation(WebMethod.class);
            if (wm != null && wm.action() != null && !wm.action().equals("")) {
                opsToSign.add(wm.action());
                continue;
            }
            logger.warn((Object)("Method <" + m.getName() + "> is marked as requiring a " + "signature but no SOAP action is defined for it. " + "This method invocations won't be signed."));
        }
        return opsToSign;
    }

    public static Map<String, OperationType> getOperationTypes(Class<?> iFace) {
        Method[] methods;
        HashMap<String, OperationType> ret = new HashMap<String, OperationType>();
        for (Method m : methods = iFace.getMethods()) {
            SEIOperationType type = m.getAnnotation(SEIOperationType.class);
            if (type == null) continue;
            if (ret.containsKey(m.getName()) && ret.get(m.getName()) != type.value()) {
                throw new IllegalStateException("Duplicated " + SEIOperationType.class.getSimpleName() + " annotation found on a method " + m.getName() + " and the values are different.");
            }
            ret.put(m.getName(), type.value());
        }
        return ret;
    }
}

