/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.xfireutil.WSSecHeader;
import eu.unicore.security.xfireutil.client.DSigOutHandler;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class TDOutHandler
extends AbstractHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.security", TDOutHandler.class);
    public static final String WSSEC_COMPILANT_PROPERTY = "eu.unicore.security.xfireutil.wssecComilant";
    private List<TrustDelegation> assertionList = null;
    private List<Element> assertionListAsJDOM = null;
    private Element userAssertionAsJDOM;
    private boolean useWssecElem;

    public TDOutHandler(List<TrustDelegation> tdChain) {
        this.init(tdChain, null, null, null);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, UserAssertion userAssertion) {
        this.init(tdChain, userAssertion);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, String userDN, String callerDN) {
        this.init(tdChain, null, userDN, callerDN);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, X509Certificate[] userCert, String callerDN) {
        this.init(tdChain, userCert, null, callerDN);
    }

    protected TDOutHandler() {
    }

    protected void initHandler() {
        this.setPhase("post-invoke");
        this.before(DSigOutHandler.class.getName());
        String prop = System.getProperty(WSSEC_COMPILANT_PROPERTY);
        if (prop != null && prop.equals("true")) {
            this.useWssecElem = true;
            logger.debug((Object)"ETD and User assertions will be placed under the wssec:Security element");
        } else {
            this.useWssecElem = false;
            logger.debug((Object)"ETD and User assertions will be placed directly under the SOAP header for backwards compatibility.");
        }
    }

    protected void init(List<TrustDelegation> tdChain, UserAssertion userAssertion) {
        this.initHandler();
        this.initJDOM(tdChain, userAssertion);
    }

    protected void init(List<TrustDelegation> tdChain, X509Certificate[] userCert, String userDN, String callerDN) {
        this.initHandler();
        UserAssertion userA = this.createUserAssertion(userCert, userDN, callerDN);
        this.initJDOM(tdChain, userA);
    }

    protected UserAssertion createUserAssertion(X509Certificate[] userCC, String userDN, String callerDN) {
        UserAssertion userA = null;
        if (userCC != null && callerDN != null) {
            try {
                userA = new UserAssertion(callerDN, userCC);
            }
            catch (Exception e) {
                logger.fatal((Object)"Can't create USER assertion: ", (Throwable)e);
            }
        } else if (userDN != null && callerDN != null) {
            userA = new UserAssertion(callerDN, userDN);
        }
        return userA;
    }

    protected void initJDOM(List<TrustDelegation> tdChain, UserAssertion userA) {
        this.assertionListAsJDOM = null;
        ArrayList arrayList = this.assertionList = tdChain != null ? tdChain : new ArrayList();
        if (this.assertionList.size() != 0) {
            this.assertionListAsJDOM = new ArrayList<Element>();
            try {
                for (TrustDelegation td : this.assertionList) {
                    this.assertionListAsJDOM.add(new SAXBuilder().build(td.getXML().newInputStream()).detachRootElement());
                }
                logger.debug((Object)("Initialised TD Outhandler with TD chain of length = " + this.assertionList.size()));
            }
            catch (Exception e) {
                logger.warn((Object)"Can't create JDOM representation of TD assertion.", (Throwable)e);
                this.assertionListAsJDOM = null;
            }
        }
        this.userAssertionAsJDOM = null;
        if (userA != null) {
            try {
                AssertionDocument user = userA.getXML();
                this.userAssertionAsJDOM = new SAXBuilder().build(user.newInputStream()).detachRootElement();
            }
            catch (Exception e) {
                logger.fatal((Object)"Can't create USER assertion: ", (Throwable)e);
                return;
            }
        }
    }

    public void invoke(MessageContext context) throws Exception {
        Element h;
        Boolean clientMode = (Boolean)context.getProperty("client.mode");
        if (clientMode == null || !clientMode.booleanValue()) {
            return;
        }
        if (this.assertionListAsJDOM == null && this.userAssertionAsJDOM == null) {
            logger.debug((Object)"Neither TD nor User assertion available.");
            return;
        }
        if (this.assertionListAsJDOM != null && logger.isTraceEnabled()) {
            logger.trace((Object)"TD DUMP begin");
            for (TrustDelegation td : this.assertionList) {
                logger.trace((Object)td.getXML().toString());
            }
            logger.trace((Object)"TD DUMP end");
        }
        Element insertionPoint = h = context.getOutMessage().getOrCreateHeader();
        if (this.useWssecElem) {
            WSSecHeader sec = new WSSecHeader(true);
            insertionPoint = sec.getOrInsertWSSecElement(h);
        }
        if (this.assertionListAsJDOM != null) {
            for (Element e : this.assertionListAsJDOM) {
                insertionPoint.addContent((Content)((Element)e.clone()));
            }
        }
        if (this.userAssertionAsJDOM != null) {
            this.userAssertionAsJDOM.detach();
            insertionPoint.addContent((Content)((Element)this.userAssertionAsJDOM.clone()));
            if (logger.isTraceEnabled()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    new XMLOutputter(Format.getPrettyFormat()).output(this.userAssertionAsJDOM, (OutputStream)bos);
                    logger.trace((Object)("User assertion:\n" + bos.toString()));
                }
                catch (Exception e) {
                    logger.warn((Object)"Can't output user assertion", (Throwable)e);
                }
            }
        }
    }
}

