/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SelfCallChecker;
import eu.unicore.security.TrustDelegationException;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.ValidationResult;
import eu.unicore.security.etd.ETDApi;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class ETDInHandler
extends AbstractHandler {
    public static final Namespace SAML2_NS = Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:2.0:assertion");
    private static final Logger logger = Log.getLogger((String)"unicore.security", ETDInHandler.class);
    private final SelfCallChecker selfCallChecker;
    private final boolean useTDIssuerAsUser;
    private X509CertChainValidator validator;

    public ETDInHandler(SelfCallChecker selfCallChecker, X509CertChainValidator validator) {
        this(selfCallChecker, false, validator);
    }

    public ETDInHandler(SelfCallChecker selfCallChecker, boolean useTDIssuerAsUser, X509CertChainValidator validator) {
        this.setPhase("policy");
        this.after(AuthInHandler.class.getName());
        this.selfCallChecker = selfCallChecker;
        this.useTDIssuerAsUser = useTDIssuerAsUser;
        this.validator = validator;
    }

    public void invoke(MessageContext ctx) throws Exception {
        if (ctx.getContextualProperty("client.mode") != null) {
            return;
        }
        SecurityTokens securityTokens = (SecurityTokens)ctx.getProperty(SecurityTokens.KEY);
        if (securityTokens == null) {
            logger.error((Object)("No security info in headers. Wrong configuration: " + AuthInHandler.class.getCanonicalName() + " handler" + " must be configure before this ETD handler."));
            return;
        }
        List<TrustDelegation> tdTokens = this.getTrustAssertionsFromHeader(securityTokens.getContext());
        securityTokens.setTrustDelegationTokens(tdTokens);
        securityTokens.setTrustDelegationValidated(false);
        securityTokens.setConsignorTrusted(false);
        X509Certificate consignor = securityTokens.getConsignorCertificate();
        if (consignor == null) {
            logger.debug((Object)"No CONSIGNOR information present (it means that request wasn't authenticated!). Trust Delegations won't be further processed.");
            return;
        }
        String etdIssuerName = this.getIssuerName(tdTokens);
        if (etdIssuerName == null) {
            logger.debug((Object)"No ETD tokens are present.");
            if (securityTokens.getUserName() == null || X500NameUtils.equal((X500Principal)securityTokens.getUserName(), (String)consignor.getSubjectX500Principal().getName())) {
                logger.debug((Object)"Performing the request with the Consignor's identity.");
                securityTokens.setConsignorTrusted(true);
            } else if (securityTokens.isConsignorUsingProxy() && X500NameUtils.equal((X500Principal)securityTokens.getUserName(), (String)securityTokens.getConsignorRealName().getName())) {
                logger.debug((Object)"Performing the request with the Consignor's identity (handling proxy which is used by consignor).");
                securityTokens.setConsignorTrusted(true);
                securityTokens.setUserName(consignor.getSubjectX500Principal());
            } else {
                logger.warn((Object)("Got request with User set to " + securityTokens.getUserName() + " without a TD! Consignor is " + X500NameUtils.getReadableForm((X500Principal)consignor.getSubjectX500Principal())));
            }
            return;
        }
        X500Principal requestedUser = securityTokens.getUserName();
        X509Certificate[] etdInitialIssuerCC = this.getIssuer(tdTokens);
        if (requestedUser != null) {
            if (!X500NameUtils.equal((X500Principal)requestedUser, (String)etdIssuerName)) {
                logger.warn((Object)("Trust delegation is present but its initial issuer differ from the requested user. Trust delegation tokens won't be verified and delegation status is set to invalid. TD Issuer: " + X500NameUtils.getReadableForm((String)etdIssuerName) + " Requested user: " + X500NameUtils.getReadableForm((X500Principal)requestedUser)));
                return;
            }
        } else if (this.useTDIssuerAsUser) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"TD was found but there is no User assertion. Using (for UNICORE clients backwards compatibility) TD chain issuer as a User on whose behalf the request will be performed.");
            }
            if (etdInitialIssuerCC != null) {
                securityTokens.setUser(etdInitialIssuerCC);
            } else {
                securityTokens.setUserName(X500NameUtils.getX500Principal((String)etdIssuerName));
            }
        } else {
            logger.debug((Object)"No user was requested so TD won't be checked. Performing the request with Consignor's identity.");
            securityTokens.setConsignorTrusted(true);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ETD issuer: " + etdIssuerName + "\nConsignor: " + X500NameUtils.getReadableForm((X500Principal)consignor.getSubjectX500Principal())));
            if (X500NameUtils.equal((X500Principal)consignor.getSubjectX500Principal(), (String)etdIssuerName)) {
                logger.debug((Object)"ETD issuer and consignor are equal");
            } else if (securityTokens.isConsignorUsingProxy() && X500NameUtils.equal((X500Principal)securityTokens.getConsignorRealName(), (String)etdIssuerName)) {
                logger.debug((Object)"ETD issuer and consignor are equal after handling a proxy");
            } else {
                logger.debug((Object)"ETD issuer and consignor are different");
            }
        }
        this.checkDelegation(securityTokens, tdTokens);
    }

    protected void checkDelegation(SecurityTokens securityTokens, List<TrustDelegation> tdTokens) throws TrustDelegationException {
        String userName = securityTokens.getUserName().getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking trust delegation issued by <" + userName + ">"));
        }
        X509Certificate consignor = securityTokens.getConsignorCertificate();
        boolean validTD = this.checkSuppliedTD(userName, tdTokens);
        boolean consignorTrusted = this.checkIfConsignorTrusted(validTD, securityTokens.isConsignorUsingProxy(), tdTokens, securityTokens.getConsignorRealName(), consignor, userName);
        securityTokens.setTrustDelegationValidated(validTD);
        securityTokens.setConsignorTrusted(consignorTrusted);
        if (validTD && consignorTrusted) {
            X509Certificate[] etdInitialIssuerCC = this.getIssuer(tdTokens);
            if (securityTokens.isSupportingProxy() && ProxyUtils.isProxy((X509Certificate[])etdInitialIssuerCC)) {
                securityTokens.setUser(new X509Certificate[]{ProxyUtils.getEndUserCertificate((X509Certificate[])etdInitialIssuerCC)});
            }
        }
    }

    protected boolean checkIfConsignorTrusted(boolean tdGenericValidity, boolean consignorIsProxy, List<TrustDelegation> tdTokens, X500Principal realConsignor, X509Certificate consignor, String user) {
        String effectiveConsignor = consignor.getSubjectX500Principal().getName();
        if (X500NameUtils.equal((X500Principal)realConsignor, (String)user)) {
            return true;
        }
        if (this.selfCallChecker != null && this.selfCallChecker.isSelfCall(consignor)) {
            logger.debug((Object)"Accept message by server as valid trust delegation.");
            return true;
        }
        if (!tdGenericValidity || tdTokens.size() == 0) {
            return false;
        }
        ETDApi etd = UnicoreSecurityFactory.getETDEngine();
        if (etd.isSubjectInChain(tdTokens, realConsignor.getName())) {
            return true;
        }
        return consignorIsProxy && etd.isSubjectInChain(tdTokens, effectiveConsignor);
    }

    protected boolean checkSuppliedTD(String user, List<TrustDelegation> td) {
        if (td.size() == 0) {
            return false;
        }
        String delegationTarget = td.get(td.size() - 1).getSubjectDN();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got TD of <" + user + "> to <" + delegationTarget + ">, " + "dumping the TD chain"));
            int i = 0;
            for (TrustDelegation t : td) {
                logger.debug((Object)("(Entry " + i++ + ") issuer: " + t.getIssuerDN() + " receiver: " + t.getSubjectDN() + " custodian: " + t.getCustodianDN()));
            }
        }
        ETDApi etd = UnicoreSecurityFactory.getETDEngine();
        ValidationResult res = etd.isTrustDelegated(td, delegationTarget, user, this.validator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validation of supplied TD result: " + res.isValid()));
        }
        if (res.isValid()) {
            return true;
        }
        logger.warn((Object)("Unsuccessful TD validation (" + user + " to " + delegationTarget + "), reason: " + res.getInvalidResaon()));
        return false;
    }

    protected List<TrustDelegation> getTrustAssertionsFromHeader(Map<String, Object> secCtx) {
        List assertions;
        ArrayList<TrustDelegation> ret = new ArrayList<TrustDelegation>();
        List list = assertions = secCtx == null ? null : (List)secCtx.get(AuthInHandler.RAW_SAML_ASSERTIONS_KEY);
        if (assertions == null || assertions.size() == 0) {
            return ret;
        }
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        for (int i = 0; i < assertions.size(); ++i) {
            try {
                AssertionDocument aDoc = AssertionDocument.Factory.parse((String)outputter.outputString((Element)assertions.get(i)));
                TrustDelegation tmp = new TrustDelegation(aDoc);
                ret.add(tmp);
                continue;
            }
            catch (Exception e) {
                logger.trace((Object)("Ignoring non-parsable as trust delegation assertion: " + e.getMessage()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TD chain length " + ret.size()));
        }
        return ret;
    }

    protected String getIssuerName(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return null;
        }
        try {
            return tdTokens.get(0).getIssuerDN();
        }
        catch (Exception e) {
            logger.warn((Object)("Can't parse ETD assertion issuer name: " + e.toString()));
            return null;
        }
    }

    protected X509Certificate[] getIssuer(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return null;
        }
        try {
            return tdTokens.get(0).getIssuerFromSignature();
        }
        catch (Exception e) {
            return null;
        }
    }
}

