/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xmlbeans.AdminActionDocument;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionValueType;
import de.fzj.unicore.wsrflite.xmlbeans.AdminService;
import de.fzj.unicore.wsrflite.xmlbeans.AdminServicePropertiesDocument;
import de.fzj.unicore.wsrflite.xmlbeans.ClearMetricDataRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.DeployServiceRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricsRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricsResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetServiceInstancesRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetServiceInstancesResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.MetricValueDocument;
import de.fzj.unicore.wsrflite.xmlbeans.ServiceEntryDocument;
import de.fzj.unicore.wsrflite.xmlbeans.UndeployServiceRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class AdminServiceClient
extends BaseWSRFClient {
    private final AdminService admin = this.makeProxy(AdminService.class);

    public AdminServiceClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public AdminServiceClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
    }

    public AdminServicePropertiesDocument getResourcePropertiesDocument() throws Exception {
        return AdminServicePropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public ServiceEntryDocument.ServiceEntry[] getServiceNames() throws Exception {
        ServiceEntryDocument.ServiceEntry[] entries = this.getResourcePropertiesDocument().getAdminServiceProperties().getServiceEntryArray();
        return entries;
    }

    public MetricValueDocument.MetricValue[] getMonitorMetrics() throws Exception {
        MetricValueDocument.MetricValue[] entries = this.getResourcePropertiesDocument().getAdminServiceProperties().getMetricValueArray();
        return entries;
    }

    public MetricValueDocument.MetricValue getMetric(String metricName) throws Exception {
        GetMetricRequestDocument req = GetMetricRequestDocument.Factory.newInstance();
        req.addNewGetMetricRequest().setName(metricName);
        GetMetricResponseDocument res = this.admin.getMetric(req);
        return res.getGetMetricResponse().getMetricValue();
    }

    public MetricValueDocument.MetricValue[] getMetrics(String[] categories, String[] metricNames) throws Exception {
        GetMetricsRequestDocument req = GetMetricsRequestDocument.Factory.newInstance();
        req.addNewGetMetricsRequest().setCategoryArray(categories);
        req.getGetMetricsRequest().setNameArray(metricNames);
        GetMetricsResponseDocument res = this.admin.getMetrics(req);
        return res.getGetMetricsResponse().getMetricValueArray();
    }

    public String[] getMetricCategories() throws Exception {
        return this.getResourcePropertiesDocument().getAdminServiceProperties().getMetricCategoryArray();
    }

    public GetServiceInstancesResponseDocument getServiceInstances(String serviceName) throws Exception {
        GetServiceInstancesRequestDocument req = GetServiceInstancesRequestDocument.Factory.newInstance();
        req.addNewGetServiceInstancesRequest().setServiceName(serviceName);
        return this.admin.getServiceInstances(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployService(String serviceName, File jarFile, boolean isPersistent) throws Exception {
        FileInputStream fin = new FileInputStream(jarFile);
        try {
            byte[] jarAsBytes = new byte[(int)jarFile.length()];
            fin.read(jarAsBytes);
            DeployServiceRequestDocument req = DeployServiceRequestDocument.Factory.newInstance();
            req.addNewDeployServiceRequest().setServiceName(serviceName);
            req.getDeployServiceRequest().setJarFile(jarAsBytes);
            req.getDeployServiceRequest().setIsPersistent(isPersistent);
            this.admin.deployService(req);
        }
        finally {
            fin.close();
        }
    }

    public void undeployService(String serviceName) throws Exception {
        UndeployServiceRequestDocument req = UndeployServiceRequestDocument.Factory.newInstance();
        req.addNewUndeployServiceRequest().setServiceName(serviceName);
        this.admin.undeployService(req);
    }

    public void clearMetricData(String metricName) throws Exception {
        ClearMetricDataRequestDocument req = ClearMetricDataRequestDocument.Factory.newInstance();
        req.addNewClearMetricDataRequest().setMetricName(metricName);
        this.admin.clearMetricData(req);
    }

    public List<AdminAction> getAdminActions() throws Exception {
        ArrayList<AdminAction> result = new ArrayList<AdminAction>();
        for (AdminActionDocument.AdminAction a : this.getResourcePropertiesDocument().getAdminServiceProperties().getAdminActionArray()) {
            result.add(new AdminAction(a.getName(), a.getDescription()));
        }
        String[] adminActions = this.getResourcePropertiesDocument().getAdminServiceProperties().getAvailableAdminActionArray();
        if (adminActions != null) {
            for (String s : adminActions) {
                result.add(new AdminAction(s, "n/a"));
            }
        }
        return result;
    }

    public AdminActionResult invokeAdminAction(String name, Map<String, String> params) throws Exception {
        AdminActionRequestDocument aard = AdminActionRequestDocument.Factory.newInstance();
        aard.addNewAdminActionRequest().setName(name);
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                AdminActionValueType p = aard.getAdminActionRequest().addNewParameter();
                p.setName(e.getKey());
                p.setValue(e.getValue());
            }
        }
        AdminActionResponseDocument response = this.admin.invokeAdminAction(aard);
        String message = response.getAdminActionResponse().getMessage();
        AdminActionValueType[] results = response.getAdminActionResponse().getResultsArray();
        boolean success = response.getAdminActionResponse().getSuccess();
        AdminActionResult result = new AdminActionResult(success, message);
        if (results != null) {
            for (AdminActionValueType r : results) {
                result.addResult(r.getName(), r.getValue());
            }
        }
        return result;
    }

    public static class AdminAction {
        public final String name;
        public final String description;

        public AdminAction(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdminAction other = (AdminAction)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static class AdminActionResult {
        private final Map<String, String> results = new HashMap<String, String>();
        private final boolean success;
        private final String message;

        public AdminActionResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean successful() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, String> getResults() {
            return this.results;
        }

        public void addResult(String name, String value) {
            if (value == null) {
                this.results.remove(name);
            }
            this.results.put(name, value);
        }
    }
}

