/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.discovery;

import eu.unicore.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ComponentFinder
implements Runnable {
    protected static final Logger logger = Log.getLogger((String)"unicore", ComponentFinder.class);
    private String componentName;
    private InetAddress bgroup;
    private int port;
    protected String key;
    private List<String> results = null;

    public List<String> getResults() {
        return this.results;
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected void doDiscover() {
        List<String> available = this.discover();
        if (available.size() > 0) {
            String reply = this.choose(available);
            this.makeResult(reply);
        } else {
            logger.warn((Object)"Nothing found.");
        }
    }

    @Override
    public void run() {
        List<String> results = this.discover();
        String reply = this.choose(results);
        this.makeResult(reply);
        this.results = results;
    }

    protected String choose(List<String> replies) {
        if (replies.size() > 0) {
            return replies.get(0);
        }
        return null;
    }

    protected abstract void makeResult(String var1);

    private List<String> discover() {
        try {
            logger.debug((Object)"Searching...");
            this.port = 7700;
            this.bgroup = InetAddress.getByName("228.5.6.7");
            int timeout = 5000;
            return this.lookup(this.getMessage(), timeout);
        }
        catch (UnknownHostException ex) {
            Log.logException((String)"", (Throwable)ex, (Logger)logger);
            return null;
        }
    }

    protected void sendRequest(String message) {
        try {
            String request = "Request:" + this.key + ":" + message;
            logger.debug((Object)("sending " + request));
            MulticastSocket s = new MulticastSocket(this.port);
            s.joinGroup(this.bgroup);
            DatagramPacket hi = new DatagramPacket(request.getBytes(), request.length(), this.bgroup, this.port);
            s.send(hi);
        }
        catch (Exception ex) {
            Log.logException((String)"Could not send multicast request: ", (Throwable)ex, (Logger)logger);
        }
    }

    private List<String> lookup(String message, int timeout) {
        ArrayList<String> results;
        block5: {
            results = new ArrayList<String>();
            this.sendRequest(message);
            String result = null;
            long startingTime = System.currentTimeMillis();
            try {
                do {
                    if ((result = this.waitForAnswer(timeout)) == null || results.contains(result)) continue;
                    try {
                        results.add(result);
                        break block5;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Received message but could not parse: " + result));
                    }
                } while (timeout <= 0 || System.currentTimeMillis() - startingTime <= (long)timeout);
                throw new IOException();
            }
            catch (IOException e) {
                if (results.size() >= 1) break block5;
                logger.debug((Object)"Discovery timed out.");
            }
        }
        return results;
    }

    private String waitForAnswer(int timeout) throws IOException {
        MulticastSocket s2 = new MulticastSocket(this.port);
        s2.joinGroup(this.bgroup);
        s2.setSoTimeout(timeout);
        byte[] buf = new byte[1000];
        DatagramPacket recv = new DatagramPacket(buf, buf.length);
        s2.receive(recv);
        String response = new String(recv.getData()).trim();
        if (response.startsWith("Response:" + this.key)) {
            logger.debug((Object)("Received: " + response + " from " + recv.getAddress()));
            return response.replaceFirst("Response:" + this.key + ":", "");
        }
        return null;
    }

    protected abstract String getMessage();
}

