/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.security.dsig.IdAttribute;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSAMLMessage {
    private static String ID_PREFIX = "SAMLY2lib_msg_";
    public static final IdAttribute PROTOCOL_ID_QNAME = new IdAttribute(null, "ID");

    public abstract Document getDOM() throws DSigException;

    public abstract void sign(PrivateKey var1, X509Certificate[] var2) throws DSigException;

    public abstract boolean isCorrectlySigned(PublicKey var1) throws DSigException;

    public abstract boolean isSigned();

    public abstract XmlObject getDoc();

    public String genID() {
        return SAMLUtils.genID(ID_PREFIX);
    }

    public void sign(PrivateKey pk) throws DSigException {
        this.sign(pk, null);
    }

    protected boolean isCorrectlySigned(PublicKey key, Document doc) throws DSigException {
        if (!this.isSigned()) {
            return false;
        }
        DigSignatureUtil sign = new DigSignatureUtil();
        return sign.verifyEnvelopedSignature(doc, Collections.singletonList(doc.getDocumentElement()), PROTOCOL_ID_QNAME, key);
    }

    protected Document signInt(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        DigSignatureUtil sign = new DigSignatureUtil();
        Document docToSign = this.getDOM();
        NodeList nodes = docToSign.getFirstChild().getChildNodes();
        Node sibling = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.getLocalName().equals("Issuer")) continue;
            if (i + 1 < nodes.getLength()) {
                sibling = nodes.item(i + 1);
                break;
            }
            sibling = null;
            break;
        }
        sign.genEnvelopedSignature(pk, null, cert, docToSign, sibling, PROTOCOL_ID_QNAME);
        return docToSign;
    }

    public abstract X509Certificate[] getIssuerFromSignature();
}

