/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.cisprovider;

import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoResponseDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoResponseDocument;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import java.math.BigInteger;
import org.apache.commons.cli.OptionBuilder;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CIPQuery
extends ActionBase {
    public static final String OPT_TOPIC_LONG = "topic";
    public static final String OPT_TOPIC = "t";
    public static final String OPT_MAXRECORDS_LONG = "maxrecords";
    public static final String OPT_MAXRECORDS = "m";
    public static final String OPT_GLUE_LONG = "glue";
    public static final String OPT_GLUE = "g";
    public static final String TSS = "TargetSystemService";
    protected String cisURL;
    private CISInfoProvider cis;
    protected String siteName;
    protected String topic;
    protected long maxRecords;
    protected boolean glue = false;

    public String getName() {
        return "cip-query";
    }

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_TOPIC_LONG);
        OptionBuilder.withDescription((String)"Topic to query");
        OptionBuilder.withArgName((String)"Topic");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_TOPIC));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_MAXRECORDS_LONG);
        OptionBuilder.withDescription((String)"Maximum number of records");
        OptionBuilder.withArgName((String)"MaxRecords");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_MAXRECORDS));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_GLUE_LONG);
        OptionBuilder.withDescription((String)"Get information in GLUE format");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)OPT_GLUE));
    }

    public void process() {
        super.process();
        this.glue = this.getBooleanOption(OPT_GLUE_LONG, OPT_GLUE);
        this.topic = this.getCommandLine().getOptionValue(OPT_TOPIC);
        if (this.topic == null) {
            this.topic = "/";
        }
        this.verbose("Requested topic '" + this.topic + "'");
        this.maxRecords = Long.parseLong(this.getCommandLine().getOptionValue(OPT_MAXRECORDS, "100"));
        this.verbose("Maximum number of records =" + this.maxRecords);
        this.siteName = this.getCommandLine().getOptionValue("s");
        if (this.siteName != null) {
            for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, (MessageWriter)this)) {
                String tName = c.getTargetSystemName();
                if (this.siteName != null && !this.siteName.equals(tName)) continue;
                String url = c.getEPR().getAddress().getStringValue();
                this.verbose("Checking TargetSystem <" + tName + "> at " + url);
                this.buildAddressFromTSSUrl(url);
            }
        } else if (this.getCommandLine().getArgs().length > 1) {
            this.cisURL = this.getCommandLine().getArgs()[1];
        }
        if (this.cisURL == null) {
            this.message("Please specify a URL or a sitename");
            this.printUsage();
            this.endProcessing(1);
        }
        this.verbose("Querying CIP at " + this.cisURL);
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(this.cisURL);
        try {
            this.cis = (CISInfoProvider)new BaseUASClient(this.cisURL, epr, this.securityProperties).makeProxy(CISInfoProvider.class);
            String result = this.glue ? this.getGlueInfo() : this.getInfo();
            this.message(result);
        }
        catch (Exception e) {
            this.error("Error querying CIS info provider at " + this.cisURL, e);
        }
    }

    protected String getInfo() throws Exception {
        GetInfoRequestDocument req = GetInfoRequestDocument.Factory.newInstance();
        req.addNewGetInfoRequest();
        req.getGetInfoRequest().setTopic(this.topic);
        req.getGetInfoRequest().setMaxNumberOfRecords(BigInteger.valueOf(this.maxRecords));
        this.verbose("Query: " + req);
        GetInfoResponseDocument res = this.cis.getInfo(req);
        if (res == null) {
            throw new Exception("Received null result. Maybe the CIP is not deployed at the site?");
        }
        return res.toString();
    }

    protected String getGlueInfo() throws Exception {
        GetGlueInfoRequestDocument req = GetGlueInfoRequestDocument.Factory.newInstance();
        req.addNewGetGlueInfoRequest();
        this.verbose("Query: " + req);
        GetGlueInfoResponseDocument res = this.cis.getGlueInfo(req);
        if (res == null) {
            throw new Exception("Received null result. Maybe the CIP is not deployed at the site?");
        }
        DomainsDocument dd = DomainsDocument.Factory.newInstance();
        dd.addNewDomains();
        dd.setDomains(res.getGetGlueInfoResponse().getDomains());
        return dd.toString();
    }

    protected void buildAddressFromTSSUrl(String url) {
        int i = url.indexOf(TSS);
        this.cisURL = url.substring(0, i) + "CISInfoProvider";
    }

    public String getDescription() {
        return "query a CIS Infoprovider at a UNICORE site";
    }

    public String getSynopsis() {
        return "Query a CIS info provider service. The VSite can be specified using the '-s' option. Alternatively the URL of the CIP service can be provided on the commandline.";
    }

    public String getArgumentList() {
        return "[CIP-URL]";
    }
}

