/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.uftp;

import de.fzj.unicore.uas.client.UFTPConstants;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.uas.fts.uftp.UFTPProperties;
import de.fzj.unicore.uas.xnjs.U6FileImportBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.util.AsyncCommandHelper;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.uftp.client.UFTPClient;
import eu.unicore.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

public class UFTPImport
extends U6FileImportBase
implements UFTPConstants {
    private String secret;
    private final boolean localMode;
    private final boolean useEncryption;
    private final UFTPProperties uftpProperties;
    private AsyncCommandHelper ach;

    public UFTPImport(Configuration config) {
        super(config);
        this.uftpProperties = (UFTPProperties)((Object)this.kernel.getAttribute(UFTPProperties.class));
        this.localMode = this.uftpProperties.getBooleanValue("client.local");
        this.useEncryption = this.uftpProperties.getBooleanValue("encryption");
    }

    public long getTransferredBytes() {
        if (this.localMode) {
            return super.getTransferredBytes();
        }
        try {
            XnjsFileWithACL x = this.configuration.getTargetSystemInterface(this.client).getProperties(this.localFile);
            if (x != null) {
                this.transferredBytes = x.getSize();
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Can't get size of local file", (Throwable)ex, (Logger)logger);
        }
        return this.transferredBytes;
    }

    public String getProtocol() {
        return ProtocolType.UFTP.toString();
    }

    protected UFTPFileTransferClient getFTClient() throws Exception {
        String url = this.fileTransferInstanceEpr.getAddress().getStringValue();
        UFTPFileTransferClient c = new UFTPFileTransferClient(url, this.fileTransferInstanceEpr, this.sec);
        c.setSecret(this.secret);
        return c;
    }

    protected Map<String, String> getExtraParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        String clientHost = this.getClientHost();
        result.put("uftp.client.host", clientHost);
        result.put("uftp.streams", this.getNumberOfStreams());
        this.secret = UUID.randomUUID().toString();
        result.put("uftp.secret", this.secret);
        result.put("uftp.encryption", String.valueOf(this.useEncryption));
        return result;
    }

    protected void doRun() throws Exception {
        if (this.localMode) {
            super.doRun();
        } else {
            this.runAsync();
        }
    }

    protected String getClientHost() {
        String clientHost = this.uftpProperties.getValue("client.host");
        if (clientHost == null) {
            if (this.localMode) {
                try {
                    clientHost = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (Exception ex) {
                    clientHost = "localhost";
                }
            } else {
                clientHost = this.uftpProperties.getValue("server.host");
            }
        }
        return clientHost;
    }

    protected String getNumberOfStreams() {
        return this.uftpProperties.getValue("streams");
    }

    protected void runAsync() throws Exception {
        String cmd = this.getCommandLine();
        this.ach = new AsyncCommandHelper(this.configuration, cmd, this.uuid, this.getParentActionID(), this.client);
        this.ach.submit();
        while (!this.ach.isDone()) {
            Thread.sleep(500L);
        }
        ResultHolder res = this.ach.getResult();
        if (res.getExitCode() == null || res.getExitCode() != 0) {
            String message = "UFTP upload failed.";
            try {
                String error = res.getStdErr();
                if (error != null) {
                    message = message + " Error details: " + error;
                }
            }
            catch (IOException ex) {
                LogUtil.logException((String)"Could not read UFTP stderr", (Throwable)ex, (Logger)logger);
            }
            throw new Exception(message);
        }
    }

    private String getCommandLine() throws Exception {
        String uftp = this.uftpProperties.getValue("client.executable");
        UFTPFileTransferClient client = this.getFTClient();
        String host = client.asString(client.getServerHosts());
        int port = client.getServerPort();
        int streams = client.getStreams();
        String key = client.getEncryptionKey();
        boolean append = IFileTransfer.OverwritePolicy.APPEND.equals((Object)this.overwrite);
        String file = this.workdir + "/" + this.localFile;
        int buf = this.uftpProperties.getIntValue("buffersize");
        return uftp + " " + UFTPClient.makeCommandline((String)host, (int)port, (String)file, (boolean)false, (String)this.secret, (int)streams, (String)key, (boolean)append, (int)buf);
    }
}

