/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.uftp;

import de.fzj.unicore.uas.client.UFTPConstants;
import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.fts.uftp.UFTPProperties;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.TimeoutRunner;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import eu.unicore.security.Client;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.server.UFTPTransferRequest;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.AuthSSLProtocolSocketFactory;
import eu.unicore.util.httpclient.IPlainClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.fts.PropertyDocument;

public class UFTPFileTransferImpl
extends FileTransferImpl
implements UFTPConstants {
    private static final Logger logger = Log.getLogger((String)"unicore.services", UFTPFileTransferImpl.class);
    @Persist
    private String clientHost;
    @Persist
    private int streams;
    private byte[] key;

    public void initialise(String sname, Map<String, Object> map) throws Exception {
        String streamsP;
        super.initialise(sname, map);
        logger.info((Object)("Creating new UFTP file transfer for client " + this.getClient()));
        this.checkAccess();
        if (this.extraParameters == null) {
            throw new IllegalArgumentException("Missing parameters for UFTP");
        }
        this.clientHost = (String)this.extraParameters.get("uftp.client.host");
        if (this.clientHost == null) {
            this.clientHost = this.getClient().getSecurityTokens().getClientIP();
            if (this.clientHost == null) {
                throw new IllegalArgumentException("Missing parameter: uftp.client.host");
            }
        }
        this.streams = (streamsP = (String)this.extraParameters.get("uftp.streams")) != null ? Integer.parseInt(streamsP) : 2;
        this.checkNumConnectionsValid();
        String secret = (String)this.extraParameters.get("uftp.secret");
        String keySpec = (String)this.extraParameters.get("uftp.encryption");
        if (keySpec != null && Boolean.parseBoolean(keySpec)) {
            logger.info((Object)"Data encryption enabled.");
            this.key = Utils.createKey();
        }
        this.publishServerParams();
        this.setupUFTP(secret);
        this.setReady();
    }

    protected void checkNumConnectionsValid() {
        UFTPProperties cfg = (UFTPProperties)((Object)this.kernel.getAttribute(UFTPProperties.class));
        int maxStreams = cfg.getIntValue("streamsLimit");
        this.streams = Math.min(maxStreams, this.streams);
    }

    protected void publishServerParams() {
        UFTPProperties cfg = (UFTPProperties)((Object)this.kernel.getAttribute(UFTPProperties.class));
        String serverHost = cfg.getValue("server.host");
        int serverPort = cfg.getIntValue("server.port");
        PropertyDocument pd = PropertyDocument.Factory.newInstance();
        pd.addNewProperty().setName("uftp.server.host");
        pd.getProperty().setValue(serverHost);
        PropertyDocument pd2 = PropertyDocument.Factory.newInstance();
        pd2.addNewProperty().setName("uftp.server.port");
        pd2.getProperty().setValue(String.valueOf(serverPort));
        PropertyDocument pd3 = PropertyDocument.Factory.newInstance();
        pd3.addNewProperty().setName("uftp.streams");
        pd3.getProperty().setValue(String.valueOf(this.streams));
        ImmutableResourceProperty ip = null;
        if (this.key != null) {
            String base64 = Utils.encodeBase64((byte[])this.key);
            PropertyDocument pd4 = PropertyDocument.Factory.newInstance();
            pd4.addNewProperty().setName("uftp.encryption_key");
            pd4.getProperty().setValue(base64);
            ip = new ImmutableResourceProperty(new XmlObject[]{pd, pd2, pd3, pd4});
        } else {
            ip = new ImmutableResourceProperty(new XmlObject[]{pd, pd2, pd3});
        }
        this.properties.put(PropertyDocument.type.getDocumentElementName(), ip);
    }

    protected void checkAccess() throws IOException {
        if (this.isExport.booleanValue()) {
            this.checkReadAccess();
        } else {
            this.checkWriteAccess();
        }
    }

    protected void checkReadAccess() throws IOException {
        InputStream is = null;
        try {
            is = this.createNewInputStream();
            is.read();
        }
        catch (Exception e) {
            throw new IOException("Can't read source file.", e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected void checkWriteAccess() throws IOException {
        OutputStream os = null;
        try {
            os = this.createNewOutputStream(true);
            os.write(new byte[0]);
            os.close();
        }
        catch (Exception e) {
            throw new IOException("Can't write to target file.", e);
        }
    }

    public void setupUFTP(String secret) throws Exception {
        UFTPProperties cfg = (UFTPProperties)((Object)this.kernel.getAttribute(UFTPProperties.class));
        String controlHost = cfg.getValue("command.host");
        int controlPort = cfg.getIntValue("command.port");
        String user = "nobody";
        String group = "nobody";
        Client c = this.getClient();
        if (c.getXlogin() != null) {
            user = c.getXlogin().getUserName();
            group = c.getXlogin().getGroup();
            logger.debug((Object)("Initiating UFTP file transfer for user '" + user + "' group '" + group + "'"));
        }
        try {
            String reply = this.initUFTPJob(controlHost, controlPort, secret, user, group, this.key);
            if (reply == null || !reply.startsWith("OK")) {
                String err = "UFTPD server reported an error";
                if (reply != null) {
                    err = err + ": " + reply.trim();
                }
                throw new IOException(err);
            }
        }
        catch (IOException ex) {
            throw new Exception("Problem communicating with the UFTP server", ex);
        }
    }

    protected String initUFTPJob(String host, int port, String secret, String user, String group, byte[] key) throws IOException {
        int timeout;
        UFTPProperties cfg;
        boolean disableSSL;
        File file = this.isExport != false ? new File(this.workdir + "/" + this.source) : new File(this.workdir + "/" + this.target);
        boolean append = this.overWrite == false;
        UFTPTransferRequest job = new UFTPTransferRequest(InetAddress.getByName(this.clientHost), this.isExport.booleanValue(), this.streams, file, append, secret, user, group, key);
        String uftpdReply = this.sendTo(host, port, job, disableSSL = (cfg = (UFTPProperties)((Object)this.kernel.getAttribute(UFTPProperties.class))).getBooleanValue("command.sslDisable").booleanValue(), timeout = cfg.getIntValue("command.socketTimeout").intValue());
        if (uftpdReply == null) {
            throw new IOException("No reply from UFTPD (timeout)");
        }
        return uftpdReply;
    }

    private String sendTo(final String host, final int port, final UFTPTransferRequest job, final boolean disableSSL, int timeout) throws IOException {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                Socket socket = null;
                if (disableSSL) {
                    socket = new Socket(InetAddress.getByName(host), port);
                } else {
                    AuthSSLProtocolSocketFactory f = new AuthSSLProtocolSocketFactory((IPlainClientConfiguration)UFTPFileTransferImpl.this.kernel.getClientConfiguration());
                    socket = f.createSocket(host, port);
                }
                logger.debug((Object)("Sending UFTP request to " + host + ":" + port + ", SSL=" + !disableSSL));
                return job.sendTo(socket);
            }
        };
        TimeoutRunner tr = new TimeoutRunner((Callable)task, this.kernel.getContainerProperties().getThreadingServices(), timeout, TimeUnit.SECONDS);
        try {
            return (String)tr.call();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }
}

