/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.helpers.StorageFactoryLister;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.util.FileUploader;
import de.fzj.unicore.ucc.workflow.GlobalFileImporter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WorkflowSystemSubmission
extends ActionBase {
    public static final String OPT_NOFIXFILENAME_LONG = "noFilenameFix";
    public static final String OPT_NOFIXFILENAME = "F";
    public static final String OPT_STORAGEURL_LONG = "storageURL";
    public static final String OPT_STORAGEURL = "S";
    protected String siteName;
    protected EndpointReferenceType storageEPR;
    private String storageFactoryURL;
    private String storageURL;
    protected StorageClient sms;
    protected Builder builder;
    protected boolean fixFilenames = true;
    protected int lifetime;
    static Pattern p = Pattern.compile("(u6://[^<|\\$]*)|(unicore6://[^<|\\$]*)");

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site name for submission");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_NOFIXFILENAME_LONG);
        OptionBuilder.withDescription((String)"Do not add the Workflow id to filenames");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_NOFIXFILENAME));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Initial workflow lifetime in hours");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"InitialLifetime");
        uCCOptions3.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"factoryURL");
        OptionBuilder.withDescription((String)"URL or site name of storage factory to use");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"StorageFactory");
        uCCOptions4.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_STORAGEURL_LONG);
        OptionBuilder.withDescription((String)"URL of storage to use for workflow data");
        OptionBuilder.withArgName((String)"Storage");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions5.addOption(OptionBuilder.create((String)OPT_STORAGEURL));
    }

    public void process() {
        super.process();
        this.siteName = this.getCommandLine().getOptionValue("s");
        this.storageFactoryURL = this.getOption("factoryURL", "f");
        this.storageURL = this.getOption(OPT_STORAGEURL_LONG, OPT_STORAGEURL);
        if (this.storageURL != null && this.storageFactoryURL != null) {
            this.error("Error: please, specify either a storage URL or a storage factory URL, but not both!", null);
            this.endProcessing(1);
        }
        if (this.getCommandLine().hasOption(OPT_NOFIXFILENAME)) {
            this.fixFilenames = false;
            this.verbose("Not adding workflow ID to global filenames.");
        }
        this.lifetime = this.getNumericOption("lifetime", "l", 24);
    }

    protected void createWorkflowDataStorage() throws Exception {
        if (this.storageURL != null) {
            this.useSpecifiedSMS();
        } else {
            this.createStorageOnFactory();
            if (this.storageEPR == null) {
                this.useSharedStorage();
            }
        }
        if (this.storageEPR != null) {
            this.verbose("Storing workflow data on storage at <" + this.storageEPR.getAddress().getStringValue() + ">");
        } else {
            this.verbose("Could not find a location for storing workflow data.");
        }
    }

    private void createStorageOnFactory() throws Exception {
        for (StorageFactoryClient sc : new StorageFactoryLister(this.registry, this.securityProperties, null)) {
            String url = sc.getEPR().getAddress().getStringValue();
            if (this.storageFactoryURL == null) {
                if (this.siteName != null && (this.siteName == null || !url.contains(this.siteName))) continue;
                this.verbose("Using storage factory at <" + url + ">");
                this.createSMS(sc);
                break;
            }
            if (!url.contains(this.storageFactoryURL)) continue;
            this.createSMS(sc);
            break;
        }
        if (this.storageFactoryURL == null) {
            this.verbose("No storage factory available.");
        }
    }

    private void createSMS(StorageFactoryClient sfc) {
        try {
            this.storageFactoryURL = sfc.getEPR().getAddress().getStringValue();
            this.verbose("Storage factory at <" + this.storageFactoryURL + "> ");
            this.sms = sfc.createSMS();
            this.storageEPR = this.sms.getEPR();
        }
        catch (Exception ex) {
            this.error("Could not create storage", ex);
            this.endProcessing(1);
        }
    }

    private void useSharedStorage() throws Exception {
        List storages = this.registry.listAccessibleServices(StorageManagement.SMS_PORT);
        if (storages.size() == 0) {
            this.verbose("No shared storages found in registry.");
            return;
        }
        this.storageEPR = (EndpointReferenceType)storages.get(0);
        if (this.siteName != null && storages.size() > 1) {
            for (EndpointReferenceType e : storages) {
                if (!e.getAddress().getStringValue().contains(this.siteName)) continue;
                this.verbose("Using storage at site " + this.siteName);
                this.storageEPR = e;
                break;
            }
        }
        this.storageURL = this.storageEPR.getAddress().getStringValue();
        this.sms = new StorageClient(this.storageEPR, this.securityProperties);
    }

    private void useSpecifiedSMS() throws Exception {
        this.verbose("Storage at <" + this.storageURL + "> ");
        this.storageURL = this.resolveU6Location(this.storageURL);
        this.storageEPR = EndpointReferenceType.Factory.newInstance();
        this.storageEPR.addNewAddress().setStringValue(this.storageURL);
        this.sms = new StorageClient(this.storageEPR, this.securityProperties);
    }

    protected void uploadLocalData(Builder builder, String uniqueID) throws IOException {
        GlobalFileImporter gif = new GlobalFileImporter(this.registry, this.securityProperties, uniqueID, (MessageWriter)this);
        gif.setStorage(this.sms);
        for (FileUploader imp : builder.getImports()) {
            String to = this.fixFilenames ? WorkflowSystemSubmission.writeNewIDs(imp.getTo(), uniqueID) : imp.getTo();
            gif.importFile(imp.getFrom(), to);
        }
    }

    public static String writeNewIDs(String s, String newID) {
        return s.replaceAll("\\$WORKFLOW_ID|\\$\\{WORKFLOW_ID\\}", newID);
    }

    public String resolveU6URLs(String s) {
        Matcher m;
        String result = s;
        while ((m = p.matcher(result)).find()) {
            String seq = m.group();
            Location l = new Location(seq, this.registry, this.securityProperties, (MessageWriter)this);
            String resolved = l.getUnicore6URI();
            this.verbose("Resolved <" + seq + "> as " + resolved);
            result = m.replaceFirst(resolved);
        }
        return result;
    }

    public String resolveU6Location(String s) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            String seq = m.group();
            Location l = new Location(seq, this.registry, this.securityProperties, (MessageWriter)this);
            String resolved = l.getSmsEpr();
            this.verbose("Resolved <" + seq + "> as " + resolved);
            return resolved;
        }
        return s;
    }
}

