/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.chemomentum.common.impl.workflow.WorkflowManagementClient;
import org.chemomentum.common.ws.IWorkflowFactory;
import org.chemomentum.common.ws.WorkflowManagement;
import org.chemomentum.workflow.xmlbeans.JobReferenceDocument;
import org.chemomentum.workflow.xmlbeans.OutputFilesDocument;
import org.chemomentum.workflow.xmlbeans.WorkflowFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WorkflowInfo
extends ListActionBase<WorkflowManagementClient> {
    private boolean listFiles;
    private boolean listJobs;

    public String getName() {
        return "workflow-info";
    }

    public String getArgumentList() {
        return "[<workflow-file>]";
    }

    public String getSynopsis() {
        return "Lists info about workflows. The workflow address is read from <workflow-file>, if not given, all workflows are shown.";
    }

    public String getDescription() {
        return "lists info on workflows.";
    }

    public String getCommandGroup() {
        return "Workflow";
    }

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"nofiles");
        OptionBuilder.withDescription((String)"Do not list global files (in detailed mode)");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"N"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"nojobs");
        OptionBuilder.withDescription((String)"Do not list jobs (in detailed mode)");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"j"));
    }

    public void process() {
        super.process();
        this.listFiles = this.detailed & !this.getBooleanOption("nofiles", "N");
        this.listJobs = this.detailed & !this.getBooleanOption("nojobs", "J");
        if (this.detailed) {
            this.verbose("Listing jobs: " + this.listJobs);
            this.verbose("Listing names of files: " + this.listFiles);
        }
        try {
            this.run();
        }
        catch (Exception e) {
            this.error("", e);
            this.endProcessing(1);
        }
    }

    protected EndpointReferenceType initEPR() throws Exception {
        EndpointReferenceType workflowEPR;
        String arg = null;
        if (this.doFilter || this.getCommandLine().getArgs().length < 2) {
            return null;
        }
        arg = this.getCommandLine().getArgs()[1];
        File wf = new File(arg);
        if (wf.exists()) {
            workflowEPR = EndpointReferenceType.Factory.parse((File)wf);
            this.verbose("Read Workflow EPR from <" + arg + ">");
        } else {
            workflowEPR = EndpointReferenceType.Factory.newInstance();
            workflowEPR.addNewAddress().setStringValue(arg);
        }
        String url = workflowEPR.getAddress().getStringValue();
        this.verbose("Checking workflow at " + url);
        return workflowEPR;
    }

    protected void run() throws Exception {
        EndpointReferenceType singleEPR = this.initEPR();
        if (singleEPR != null) {
            WorkflowManagementClient wf = new WorkflowManagementClient(singleEPR.getAddress().getStringValue(), singleEPR, this.securityProperties);
            if (this.filterMatch((BaseWSRFClient)wf)) {
                this.listOne(wf);
            }
            return;
        }
        List workflowServices = this.registry.listAccessibleServices(IWorkflowFactory.PORTTYPE);
        for (EndpointReferenceType epr : workflowServices) {
            try {
                EndpointReferenceType[] eprs;
                this.verbose("Listing workflows from " + epr.getAddress().getStringValue());
                BaseUASClient bc = new BaseUASClient(epr.getAddress().getStringValue(), epr, this.securityProperties);
                WorkflowFactoryPropertiesDocument wfpd = WorkflowFactoryPropertiesDocument.Factory.parse((InputStream)bc.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
                for (EndpointReferenceType workflowEPR : eprs = wfpd.getWorkflowFactoryProperties().getAccessibleWorkflowReferenceArray()) {
                    try {
                        WorkflowManagementClient wf = new WorkflowManagementClient(workflowEPR.getAddress().getStringValue(), workflowEPR, this.securityProperties);
                        if (!this.filterMatch((BaseWSRFClient)wf)) continue;
                        this.listOne(wf);
                    }
                    catch (Exception e) {
                        this.verbose("Error accessing workflow at: " + workflowEPR.getAddress().getStringValue());
                    }
                }
            }
            catch (Exception e) {
                this.error("Error accessing workflow service at: " + epr.getAddress().getStringValue(), e);
            }
        }
    }

    protected void listOne(WorkflowManagementClient workflow) throws Exception {
        this.message(workflow.getEPR().getAddress().getStringValue() + this.getDetails(workflow));
        this.printWSRFProperties((BaseWSRFClient)workflow);
    }

    protected String getDetails(WorkflowManagementClient workflow) throws Exception {
        EndpointReferenceType tracerEPR;
        if (!this.detailed) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        String sep = System.getProperty("line.separator");
        details.append(sep);
        details.append("  Status: ").append(workflow.getStatus());
        EndpointReferenceType storageEPR = workflow.getStorageAddress();
        if (storageEPR != null) {
            details.append(sep).append("  Storage: ").append(storageEPR.getAddress().getStringValue());
        }
        if ((tracerEPR = workflow.getTracerAddress()) != null) {
            details.append(sep).append("  Tracer: ").append(tracerEPR.getAddress().getStringValue());
        }
        if (this.listFiles) {
            this.listFiles(workflow, details);
        }
        try {
            EndpointReferenceType jobList = workflow.getResourcePropertiesDocument().getWorkflowResourceProperties().getJobReferenceEnumeration();
            QName qname = JobReferenceDocument.type.getDocumentElementName();
            EnumerationClient enClient = new EnumerationClient(jobList, this.securityProperties, qname);
            details.append(sep).append("  Number of jobs: ").append(enClient.getNumberOfResults());
            if (this.listJobs) {
                this.listJobs((EnumerationClient<JobReferenceDocument>)enClient, details);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't access job list.", (Throwable)e);
        }
        return details.toString();
    }

    protected void listFiles(WorkflowManagementClient workflow, StringBuilder details) {
        try {
            String[] outFiles;
            String sep = System.getProperty("line.separator");
            OutputFilesDocument od = OutputFilesDocument.Factory.parse((String)workflow.getResourceProperty(WorkflowManagement.RPOutputFiles));
            for (String file : outFiles = od.getOutputFiles().getOutputFileArray()) {
                details.append(sep).append("  File: ").append(file);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't retrieve output files", (Throwable)e);
        }
    }

    protected void listJobs(EnumerationClient<JobReferenceDocument> enClient, StringBuilder details) {
        String sep = System.getProperty("line.separator");
        try {
            Iterator iter = enClient.iterator();
            while (iter.hasNext()) {
                details.append(sep).append("  Job: ").append(((JobReferenceDocument)iter.next()).getJobReference().getAddress().getStringValue());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't process job list.", (Throwable)e);
        }
    }
}

