/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.chemomentum.common.impl.workflow.WorkflowManagementClient;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WorkflowControl
extends ActionBase {
    private EndpointReferenceType workflowEPR;
    private String workflowID;
    private WorkflowManagementClient workflow;
    private String cmd;
    final Map<String, String> parameters = new HashMap<String, String>();
    static Map<String, String> lastParams;

    public String getName() {
        return "workflow-control";
    }

    public String getArgumentList() {
        return "abort <workflow-file-or-address> | resume <workflow-file-or-address> [key1=value1 key2=value2 ...]";
    }

    public String getSynopsis() {
        return "Allows to abort or resume (if held) a workflow ";
    }

    public String getDescription() {
        return "offers workflow control functions";
    }

    protected void createOptions() {
        super.createOptions();
    }

    public void process() {
        super.process();
        try {
            this.run();
        }
        catch (Exception e) {
            this.error("", e);
            this.endProcessing(1);
        }
    }

    protected void getBasicCmdlineParams() throws Exception {
        File wf;
        this.cmd = this.getCommandLine().getArgs()[1];
        String arg = null;
        if (this.getCommandLine().getArgs().length > 2) {
            arg = this.getCommandLine().getArgs()[2];
        }
        if (arg == null) {
            try {
                arg = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (Exception e) {
                this.error("Can't read workflow address from stdin.", e);
                this.endProcessing(1);
            }
        }
        if ((wf = new File(arg)).exists()) {
            this.workflowEPR = EndpointReferenceType.Factory.parse((File)wf);
            this.verbose("Read Workflow EPR from <" + arg + ">");
        } else {
            this.workflowEPR = EndpointReferenceType.Factory.newInstance();
            this.workflowEPR.addNewAddress().setStringValue(arg);
        }
        String url = this.workflowEPR.getAddress().getStringValue();
        this.verbose("Checking workflow at " + url);
        this.workflow = new WorkflowManagementClient(url, this.workflowEPR, this.securityProperties);
        this.workflowID = WSUtilities.extractResourceID((EndpointReferenceType)this.workflow.getEPR());
    }

    protected void run() throws Exception {
        this.getBasicCmdlineParams();
        this.readExtraParameters();
        if ("abort".equalsIgnoreCase(this.cmd)) {
            this.doAbort();
        }
        if ("resume".equalsIgnoreCase(this.cmd)) {
            this.doResume();
        }
    }

    protected void readExtraParameters() {
        this.parameters.clear();
        int length = this.getCommandLine().getArgs().length;
        if (length < 3) {
            return;
        }
        for (int i = 3; i < length; ++i) {
            String p = this.getCommandLine().getArgs()[i];
            String[] split = p.split("=");
            String key = split[0];
            String value = split[1];
            this.verbose("Have parameter: " + key + "=" + value);
            this.parameters.put(key, value);
        }
        lastParams = this.parameters;
    }

    protected void doAbort() throws Exception {
        this.verbose("Aborting workflow " + this.workflowEPR.getAddress().getStringValue());
        if (!UCC.unitTesting) {
            this.workflow.abort();
        }
    }

    protected void doResume() throws Exception {
        this.verbose("Resuming workflow " + this.workflowEPR.getAddress().getStringValue());
        if (!UCC.unitTesting) {
            this.workflow.resume(this.parameters);
        }
    }

    public String getCommandGroup() {
        return "Workflow";
    }
}

