/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.Resolve;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.ucc.helpers.IResolve;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.workflow.LocationResolver;
import de.fzj.unicore.ucc.workflow.WorkflowSystemSubmission;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.cli.OptionBuilder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.chemomentum.common.api.workflow.WorkflowWrapper;
import org.chemomentum.common.impl.workflow.WorkflowManagementClient;
import org.chemomentum.common.impl.workflow.WorkflowSubmissionClient;
import org.chemomentum.common.ws.IWorkflowFactory;
import org.chemomentum.workflow.xmlbeans.RulesDocument;
import org.chemomentum.workflow.xmlbeans.StatusType;
import org.chemomentum.workflow.xmlbeans.WorkflowDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class SubmitWorkflow
extends WorkflowSystemSubmission
implements IServiceInfoProvider {
    public static final String OPT_NAME_LONG = "workflowName";
    public static final String OPT_NAME = "N";
    public static final String OPT_UFILE_LONG = "uccInput";
    public static final String OPT_UFILE = "u";
    public static final String OPT_LIFETIME = "t";
    public static final String OPT_LIFETIME_LONG = "lifetime";
    public static final String OPT_WAIT = "w";
    public static final String OPT_WAIT_LONG = "wait";
    protected String workflowName;
    protected WorkflowSubmissionClient wsc;
    protected String workflowToBeSubmitted;
    protected StatusType.Enum status;
    protected String workflowFileName;
    protected boolean wait = false;

    @Override
    public void process() {
        super.process();
        this.workflowName = this.getCommandLine().getOptionValue(OPT_NAME);
        if (this.getCommandLine().hasOption(OPT_WAIT)) {
            this.wait = true;
        }
        if (this.getCommandLine().getArgs().length < 2) {
            this.error("Please supply the name of the workflow file,", new IllegalArgumentException());
            this.endProcessing(1);
        } else {
            this.workflowFileName = this.getCommandLine().getArgs()[1];
        }
        try {
            this.findSite();
            this.createBuilder();
            this.createWorkflowDataStorage();
            this.run();
        }
        catch (Exception e) {
            this.error("", e);
            this.endProcessing(1);
        }
    }

    protected void createBuilder() throws Exception {
        String uFile = this.getOption(OPT_UFILE_LONG, OPT_UFILE);
        if (uFile != null) {
            this.verbose("Reading stage-in definitions from <" + uFile + ">");
            this.builder = new Builder(new File(uFile));
            int n = this.builder.getImports().size();
            this.verbose("Will upload <" + n + "> files");
        }
    }

    protected void findSite() {
        try {
            List available = this.registry.listAccessibleServices(IWorkflowFactory.PORTTYPE);
            for (EndpointReferenceType epr : available) {
                String addr;
                if (this.siteName == null || !(addr = epr.getAddress().getStringValue()).contains(this.siteName)) continue;
                this.wsc = new WorkflowSubmissionClient(addr, epr, this.securityProperties);
                this.verbose("Using service <" + addr + "> at requested site <" + this.siteName + ">");
                return;
            }
            int i = 0;
            if (available.size() == 0) {
                this.message("No workflow service available!");
                this.endProcessing(1);
            } else {
                EndpointReferenceType epr;
                i = new Random().nextInt(available.size());
                epr = (EndpointReferenceType)available.get(i);
                this.wsc = new WorkflowSubmissionClient(epr.getAddress().getStringValue(), epr, this.securityProperties);
            }
            this.verbose("Selected workflow service at " + this.wsc.getEPR().getAddress().getStringValue());
        }
        catch (Exception e) {
            this.error("Can't find a workflow service.", e);
            this.endProcessing(1);
        }
    }

    protected void run() throws Exception {
        this.loadWorkflowFromFile();
        Calendar terminationTime = Calendar.getInstance();
        terminationTime.add(10, this.lifetime);
        this.verbose("Setting initial termination time to " + terminationTime.getTime());
        String uFile = this.getOption(OPT_UFILE_LONG, OPT_UFILE);
        if (uFile != null) {
            this.verbose("Reading stage-in definitions from <" + uFile + ">");
            this.builder = new Builder(new File(uFile));
            int n = this.builder.getImports().size();
            this.verbose("Will upload <" + n + "> files");
        }
        WorkflowManagementClient wmc = this.wsc.createWorkflow(this.workflowName, terminationTime, this.storageEPR);
        EndpointReferenceType epr = wmc.getEPR();
        String id = WSUtilities.extractResourceID((EndpointReferenceType)epr);
        if (this.fixFilenames) {
            this.workflowToBeSubmitted = SubmitWorkflow.writeNewIDs(this.workflowToBeSubmitted, id);
        }
        this.workflowToBeSubmitted = this.resolveU6URLs(this.workflowToBeSubmitted);
        this.verbose("Workflow instance EPR: " + epr.getAddress().getStringValue());
        WorkflowDocument wf = this.load();
        boolean validWF = this.isValid(wf);
        if (!validWF) {
            boolean failOnError = Boolean.parseBoolean(this.properties.getProperty("ucc.validation.fail_on_errors"));
            if (failOnError) {
                String message = "Stopping due to validation errors (set property 'ucc.validation.fail_on_errors=false' to ignore them)";
                throw new EndProcessingException(5, message);
            }
            this.verbose("Ignoring validation errors because property ucc.validation.fail_on_errors is set to 'false'.");
        }
        RulesDocument rd = RulesDocument.Factory.newInstance();
        rd.addNewRules();
        if (this.builder != null) {
            try {
                this.uploadLocalData(this.builder, id);
            }
            catch (IOException e) {
                this.error("Can't upload local files.", e);
                this.endProcessing(1);
            }
        }
        WorkflowWrapper w = new WorkflowWrapper(wf.getWorkflow(), rd.getRules());
        w.setTerminationTime(terminationTime);
        this.verbose("Submitting...");
        wmc.submitWorkflow(w);
        this.writeIDFile(epr);
        this.message(epr.getAddress().getStringValue());
        if (this.wait) {
            this.verbose("Waiting for workflow to finish...");
            do {
                Thread.sleep(2000L);
                StatusType.Enum newStatus = wmc.getStatus();
                if (newStatus == null) {
                    this.error("Can't get workflow status.", null);
                    break;
                }
                if (newStatus.equals(this.status)) continue;
                this.status = newStatus;
                this.verbose(this.status.toString());
            } while (StatusType.RUNNING.equals(this.status));
        }
    }

    WorkflowDocument load() throws Exception {
        WorkflowDocument wf = WorkflowDocument.Factory.newInstance();
        String dialect = null;
        XmlObject x = XmlObject.Factory.parse((String)this.workflowToBeSubmitted);
        wf.addNewWorkflow().set(x);
        dialect = x.newDomNode().getFirstChild().getNamespaceURI();
        wf.getWorkflow().setDialect(dialect);
        this.verbose("Workflow dialect '" + dialect + "'");
        return wf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadWorkflowFromFile() throws Exception {
        FileInputStream fis = new FileInputStream(new File(this.workflowFileName).getAbsolutePath());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = fis.read()) != -1) {
                bos.write(b);
            }
            this.workflowToBeSubmitted = bos.toString();
        }
        finally {
            fis.close();
        }
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_NAME_LONG);
        OptionBuilder.withDescription((String)"Workflow Name");
        OptionBuilder.withArgName((String)"Name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)OPT_NAME));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_UFILE_LONG);
        OptionBuilder.withDescription((String)"UCC .u file with stage-in definitions");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_UFILE));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_WAIT_LONG);
        OptionBuilder.withDescription((String)"wait for workflow completion");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_WAIT));
    }

    protected void writeIDFile(EndpointReferenceType epr) {
        try {
            File dump = new File(this.output, WSUtilities.extractResourceID((EndpointReferenceType)epr) + ".workflow-address");
            FileWriter fw = new FileWriter(dump);
            fw.write(epr.toString() + "\n");
            fw.close();
            this.verbose("Wrote workflow address to " + dump.getAbsolutePath());
        }
        catch (Exception e) {
            this.error("Could not write workflow ID file.", e);
        }
    }

    public String getName() {
        return "workflow-submit";
    }

    public String getArgumentList() {
        return "[<workflow-file>]";
    }

    public String getSynopsis() {
        return "Runs a workflow. The workflow definition is read from <workflow-file>.A descriptor file will be written that can be used later with other ucc commands.";
    }

    public String getDescription() {
        return "submit a workflow";
    }

    public String getCommandGroup() {
        return "Workflow";
    }

    public QName getQName() {
        return IWorkflowFactory.PORTTYPE;
    }

    public String getServiceName() {
        return "Workflow submission";
    }

    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration security) {
        try {
            WorkflowSubmissionClient wsc = new WorkflowSubmissionClient(epr.getAddress().getStringValue(), epr, security);
            return "Version: " + wsc.getResourcePropertiesDocument().getWorkflowFactoryProperties().getVersion();
        }
        catch (Exception ex) {
            this.error("Can't get workflow service details", ex);
            return null;
        }
    }

    protected boolean isValid(WorkflowDocument workflow) throws XmlException {
        boolean isValid = true;
        List<JobDescriptionDocument> jsdls = SubmitWorkflow.extractAnyElements((XmlObject)workflow, JobDescriptionDocument.type.getDocumentElementName(), JobDescriptionDocument.class);
        this.verbose("Validating " + jsdls.size() + " JSDL job definitions.");
        for (JobDescriptionDocument j : jsdls) {
            try {
                JobDefinitionDocument jdd = JobDefinitionDocument.Factory.newInstance();
                JobDescriptionDocument jdesc = j;
                jdd.addNewJobDefinition().setJobDescription(jdesc.getJobDescription());
                boolean isValidPart = Builder.isValidJSDL((JobDefinitionDocument)jdd, (MessageWriter)this);
                isValid &= isValidPart;
            }
            catch (Exception ex) {
                this.error("", ex);
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> extractAnyElements(XmlObject source, QName q, Class<? extends XmlObject> asClass) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        XmlCursor cursor = null;
        String ns = q.getNamespaceURI();
        try {
            if (source != null) {
                cursor = source.newCursor();
                while (SubmitWorkflow.skipToElement(cursor, q)) {
                    XmlObject next = XmlObject.Factory.parse((XMLStreamReader)cursor.newXMLStreamReader());
                    QName name = cursor.getName();
                    if (name == null || !ns.equals(name.getNamespaceURI()) && !"*".equals(ns) || !q.getLocalPart().equals(name.getLocalPart())) continue;
                    results.add(next);
                }
            }
        }
        catch (XmlException xe) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return results;
    }

    public static boolean skipToElement(XmlCursor cursor, QName name) {
        while (cursor.hasNextToken()) {
            XmlCursor.TokenType tt = cursor.toNextToken();
            if (!tt.isStart() || !name.equals(cursor.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        Resolve.addResolver((String)"c9m:", (IResolve)new LocationResolver());
    }
}

