/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.Resolve;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.util.FileDownloader;
import de.fzj.unicore.ucc.workflow.WorkflowSystemSubmission;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.chemomentum.common.ws.IServiceOrchestrator;
import org.chemomentum.workassignment.xmlbeans.GetWorkAssignmentStatusRequestDocument;
import org.chemomentum.workassignment.xmlbeans.GetWorkAssignmentStatusResponseDocument;
import org.chemomentum.workassignment.xmlbeans.StatusType;
import org.chemomentum.workassignment.xmlbeans.SubmitWorkAssignmentRequestDocument;
import org.chemomentum.workassignment.xmlbeans.WorkAssignmentType;
import org.chemomentum.workassignment.xmlbeans.WorkDocument;
import org.chemomentum.workflow.callback.xmlbeans.ExecutionResourcesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class SubmitWorkAssignment
extends WorkflowSystemSubmission
implements IServiceInfoProvider {
    protected String workflowName;
    protected IServiceOrchestrator wsc;
    protected EndpointReferenceType servorchEPR;
    protected EndpointReferenceType jobEPR;
    protected String waID;
    protected boolean async = false;

    @Override
    public void process() {
        super.process();
        this.workflowName = this.getCommandLine().getOptionValue("N");
        if (this.getCommandLine().hasOption("a")) {
            this.async = true;
        }
        this.waID = WSUtilities.newUniqueID();
        try {
            this.findSite();
            this.initBuilder(this.waID);
            this.run();
        }
        catch (Exception e) {
            this.error("", e);
            this.endProcessing(1);
        }
    }

    protected void findSite() {
        String addr = null;
        try {
            List available = this.registry.listAccessibleServices(IServiceOrchestrator.PORT);
            for (EndpointReferenceType epr : available) {
                if (this.siteName == null || !(addr = epr.getAddress().getStringValue()).contains(this.siteName)) continue;
                this.servorchEPR = epr;
                this.setReceiver();
                this.wsc = (IServiceOrchestrator)new UnicoreXFireClientFactory(this.securityProperties).createPlainWSProxy(IServiceOrchestrator.class, addr);
                this.verbose("Using service <" + addr + "> at requested site <" + this.siteName + ">");
                return;
            }
            int i = 0;
            if (available.size() == 0) {
                this.message("No service orchestrator service available!");
                this.endProcessing(1);
            } else {
                i = new Random().nextInt(available.size());
                this.servorchEPR = (EndpointReferenceType)available.get(i);
                this.setReceiver();
                addr = this.servorchEPR.getAddress().getStringValue();
                this.wsc = (IServiceOrchestrator)new UnicoreXFireClientFactory(this.securityProperties).createPlainWSProxy(IServiceOrchestrator.class, addr);
            }
            this.verbose("Selected workflow service at " + addr);
        }
        catch (Exception e) {
            this.error("Can't find a workflow service.", e);
            this.endProcessing();
        }
    }

    private void setReceiver() {
        String dn = null;
        try {
            dn = WSUtilities.extractServerIDFromEPR((EndpointReferenceType)this.servorchEPR);
            if (dn != null) {
                this.securityProperties.getETDSettings().setReceiver(new X500Principal(dn));
            }
        }
        catch (IllegalArgumentException e) {
            try {
                logger.warn((Object)("Invalid server name <" + dn + "> found in EPR " + this.servorchEPR.getAddress().getStringValue() + ". Not an X500 name."));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected void run() throws Exception {
        SubmitWorkAssignmentRequestDocument in = SubmitWorkAssignmentRequestDocument.Factory.newInstance();
        WorkAssignmentType wa = in.addNewSubmitWorkAssignmentRequest().addNewWorkAssignment();
        WorkDocument.Work work = wa.addNewWork();
        work.setJobDefinition(this.builder.getJob().getJobDefinition());
        wa.setParent("Submitted_by_UCC");
        wa.setId(this.waID);
        if (this.builder.getImports().size() > 0) {
            this.createWorkflowDataStorage();
            wa.setStorageEPR(this.storageEPR);
            try {
                this.uploadLocalData(this.builder, this.waID);
            }
            catch (IOException ex) {
                this.error("Can't upload local files.", ex);
                this.endProcessing(1);
            }
        }
        logger.debug((Object)("Submitting " + String.valueOf(in)));
        this.wsc.submitWorkAssignment(in);
        if (!this.async) {
            try {
                this.waitForFinish();
            }
            catch (Exception ex) {
                this.error("Work assignment did not finish successfully", ex);
                this.endProcessing(1);
            }
            if (this.builder.getExports().size() > 0) {
                for (FileDownloader exp : this.builder.getExports()) {
                    this.performExportToLocal(exp);
                }
            }
        }
    }

    protected void performExportToLocal(FileDownloader e) {
        String name = this.waID + "_" + e.getTo();
        File out = new File(name);
        if (!out.isAbsolute()) {
            out = new File(this.output, name);
        }
        try {
            Location l = Resolve.resolve((String)e.getFrom(), (IRegistryQuery)this.registry, (IClientConfiguration)this.securityProperties, (MessageWriter)this);
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(l.getSmsEpr());
            StorageClient sms = new StorageClient(l.getSmsEpr(), epr, this.securityProperties);
            FileDownloader e1 = new FileDownloader(l.getName(), out.getAbsolutePath(), e.getMode());
            e1.perform(sms, (MessageWriter)this);
        }
        catch (Exception ex) {
            this.error("Could not perform export " + e.getFrom() + "->" + e.getTo(), ex);
        }
    }

    protected void waitForFinish() throws Exception {
        this.verbose("Waiting for work assignment to finish...");
        StatusType.Enum s = null;
        boolean havePrintedJobEPR = false;
        GetWorkAssignmentStatusResponseDocument res = null;
        while (true) {
            ExecutionResourcesDocument.ExecutionResources er;
            GetWorkAssignmentStatusRequestDocument gs = GetWorkAssignmentStatusRequestDocument.Factory.newInstance();
            gs.addNewGetWorkAssignmentStatusRequest().setId(this.waID);
            res = this.wsc.getWorkAssignmentStatus(gs);
            StatusType.Enum newStatus = res.getGetWorkAssignmentStatusResponse().getStatusResult();
            if (!newStatus.equals(s)) {
                s = newStatus;
                this.message(String.valueOf(s));
            }
            if ((er = res.getGetWorkAssignmentStatusResponse().getExecutionResources()) != null) {
                this.jobEPR = er.getJob();
                if (this.jobEPR != null && !havePrintedJobEPR) {
                    this.message("Job submitted as: " + er.getJob().getAddress().getStringValue());
                    havePrintedJobEPR = true;
                }
            }
            if (StatusType.FAILURE.equals(s) || StatusType.SUCCESS.equals(s)) break;
            Thread.sleep(2000L);
        }
        this.message("Work assignment finished: " + s);
    }

    private void initBuilder(String uniqueID) throws Exception {
        if (this.getCommandLine().getArgs().length < 1) {
            this.error("Please supply the name of the job file,", new IllegalArgumentException());
            this.endProcessing(1);
        }
        String filename = this.getCommandLine().getArgs()[1];
        this.verbose("Loading job from <" + filename + ">");
        FileInputStream fis = new FileInputStream(new File(filename).getAbsolutePath());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int b = 0;
        while ((b = fis.read()) != -1) {
            bos.write(b);
        }
        String job = bos.toString();
        if (this.fixFilenames) {
            job = SubmitWorkAssignment.writeNewIDs(job, uniqueID);
        }
        this.builder = new Builder(job);
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"asynchronous");
        OptionBuilder.withDescription((String)"Run asynchronously");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"a"));
    }

    protected void writeIDFile(EndpointReferenceType epr) {
        try {
            File dump = new File(this.output, WSUtilities.extractResourceID((EndpointReferenceType)epr) + ".workassignment-address");
            FileWriter fw = new FileWriter(dump);
            fw.write(epr.toString() + "\n");
            fw.close();
            this.verbose("Wrote work assignment address to " + dump.getAbsolutePath());
        }
        catch (Exception e) {
            this.error("Could not write workflow ID file.", e);
        }
    }

    public String getName() {
        return "broker-run";
    }

    public String getArgumentList() {
        return "[<job-file>]";
    }

    public String getSynopsis() {
        return "Runs a job through the Chemomentum service orchestrator. The job definition (in UCC's JSON format) is read from <job-file>.A descriptor file will be written that can be used later with other ucc commands.";
    }

    public String getDescription() {
        return "submit a work assignment to a service orchestrator";
    }

    public String getCommandGroup() {
        return "Workflow";
    }

    public QName getQName() {
        return IServiceOrchestrator.PORT;
    }

    public String getServiceName() {
        return "Service orchestrator";
    }

    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration security) {
        return null;
    }
}

