/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.List;
import org.chemomentum.common.ws.ILocationManager;
import org.chemomentum.dataManagement.locationManager.QueryLocationRequestDocument;
import org.chemomentum.dataManagement.locationManager.QueryLocationResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class LocationMapperLocation
extends Location {
    public LocationMapperLocation(String desc, IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        super(desc, registry, sec, msg);
    }

    protected boolean parseDesc(String desc) {
        if (this.doResolve && desc.startsWith("c9m")) {
            return this.resolveC9MLocation(desc);
        }
        return super.parseDesc(desc);
    }

    private boolean resolveC9MLocation(String desc) {
        try {
            List available = this.registry.listServices(ILocationManager.PORT);
            if (available.size() == 0) {
                this.msg.message("No location mapping service available!");
            }
            for (EndpointReferenceType epr : available) {
                String url = epr.getAddress().getStringValue();
                this.msg.verbose("Querying location mapping service at " + url);
                ILocationManager lm = (ILocationManager)new UnicoreXFireClientFactory(this.sec).createPlainWSProxy(ILocationManager.class, url);
                QueryLocationRequestDocument req = QueryLocationRequestDocument.Factory.newInstance();
                req.addNewQueryLocationRequest().addNewInput().setLogicalName(desc);
                QueryLocationResponseDocument res = lm.queryLocation(req);
                if (res.getQueryLocationResponse().getFaultsOccurred()) {
                    this.msg.verbose("Could not resolve location, result " + res);
                    continue;
                }
                String[] locs = res.getQueryLocationResponse().getResultArray(0).getPhysicalLocationArray();
                if (locs.length > 0) {
                    String l = locs[0];
                    this.msg.message("Resolved logical location as: " + l);
                    return super.parseDesc(l);
                }
                return false;
            }
        }
        catch (Exception e) {
            this.msg.error("Can't resolve location using available location mappers.", (Throwable)e);
        }
        this.msg.message("No physical location found!");
        return false;
    }
}

