/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.workflow;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.chemomentum.common.ws.ILocationManager;
import org.chemomentum.dataManagement.locationManager.StoreLocationRequestDocument;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GlobalFileImporter {
    private IRegistryQuery registry;
    private String workflowID;
    private MessageWriter msg;
    private boolean haveInit;
    private ILocationManager locationMapper;
    private IClientConfiguration securityProperties;
    private StorageClient storageClient;
    private EndpointReferenceType epr;

    public GlobalFileImporter() {
    }

    public GlobalFileImporter(IRegistryQuery registry, IClientConfiguration sec, String workflowID, MessageWriter msg) {
        this.registry = registry;
        this.securityProperties = sec;
        this.workflowID = workflowID;
        this.msg = msg;
    }

    public IRegistryQuery getRegistry() {
        return this.registry;
    }

    public void setRegistry(IRegistryQuery registry) {
        this.registry = registry;
    }

    public String getWorkflowID() {
        return this.workflowID;
    }

    public void setWorkflowID(String workflowID) {
        this.workflowID = workflowID;
    }

    public void importFile(String localPath, String globalName) throws IOException {
        try {
            this.initialise();
        }
        catch (Exception e) {
            this.msg.error("Can't initialise", (Throwable)e);
            throw new IOException("Can't initialise! Reason: " + e.getMessage());
        }
        String physicalLocation = null;
        String name = "inputfiles/" + new File(localPath).getName();
        try {
            physicalLocation = "BFT:" + this.storageClient.getEPR().getAddress().getStringValue() + "#/" + this.workflowID + "/" + name;
            this.registerName(globalName, physicalLocation);
        }
        catch (Exception e) {
            this.msg.error("Can't register global name", (Throwable)e);
            throw new IOException("Can't register global name! Reason: " + e.getMessage());
        }
        try {
            FileInputStream source = new FileInputStream(new File(localPath).getAbsolutePath());
            this.storageClient.getImport("/" + this.workflowID + "/" + name, new ProtocolType.Enum[]{ProtocolType.BFT, ProtocolType.RBYTEIO}).writeAllData((InputStream)source);
        }
        catch (Exception e) {
            this.msg.error("Can't register global name", (Throwable)e);
            throw new IOException("Can't register global name! Reason: " + e.getMessage());
        }
    }

    protected void registerName(String name, String location) throws Exception {
        StoreLocationRequestDocument requestDocument = StoreLocationRequestDocument.Factory.newInstance();
        StoreLocationRequestDocument.StoreLocationRequest.Input in = requestDocument.addNewStoreLocationRequest().addNewInput();
        in.setLogicalName(name);
        in.addNewPhysicalLocation().setStringValue(location);
        this.locationMapper.storeLocation(requestDocument);
        this.msg.verbose("Registered global name <" + name + "> with location <" + location + ">");
    }

    protected void initialise() {
        if (this.haveInit) {
            return;
        }
        this.haveInit = true;
        try {
            List available = this.registry.listServices(ILocationManager.PORT);
            int index = 0;
            if (available.size() == 0) {
                this.msg.message("No location mapping service available!");
                index = -1;
            } else if (available.size() > 1) {
                this.msg.verbose("Too many location mapper services available... using first one");
                index = 0;
            }
            if (index >= 0) {
                this.epr = (EndpointReferenceType)available.get(0);
                String url = this.epr.getAddress().getStringValue();
                this.msg.verbose("Querying location mapping service at " + url);
                this.locationMapper = (ILocationManager)new UnicoreXFireClientFactory(this.securityProperties).createPlainWSProxy(ILocationManager.class, url);
                return;
            }
        }
        catch (Exception e) {
            this.msg.error("Can't access location mapper.", (Throwable)e);
        }
    }

    public void setStorage(StorageClient sms) {
        this.storageClient = sms;
    }

    public void setMsg(MessageWriter msg) {
        this.msg = msg;
    }
}

