/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.client;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.util.ActivityUtils;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesType;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class FactoryClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger((String)"unicore.client", ActivityClient.class);
    private final BESFactory factory = (BESFactory)this.makeProxy(BESFactory.class);

    public FactoryClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public FactoryClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public CreateActivityResponseDocument createActivity(CreateActivityDocument req) throws NotAcceptingNewActivitiesFault, InvalidRequestMessageFault, UnsupportedFeatureFault {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Calling Service: " + this.epr.getAddress().getStringValue()));
        }
        return this.factory.CreateActivity(req);
    }

    public GetActivityStatusesResponseDocument getActivityStatuses(GetActivityStatusesDocument req) throws UnknownActivityIdentifierFault {
        GetActivityStatusesResponseDocument res = this.factory.GetActivityStatuses(req);
        return res;
    }

    public TerminateActivitiesResponseDocument terminateActivities(TerminateActivitiesDocument req) throws UnknownActivityIdentifierFault {
        TerminateActivitiesResponseDocument res = this.factory.TerminateActivities(req);
        return res;
    }

    public TerminateActivitiesResponseType terminateActivity(EndpointReferenceType eprt) throws UnknownActivityIdentifierFault {
        TerminateActivitiesDocument tActDoc = TerminateActivitiesDocument.Factory.newInstance();
        TerminateActivitiesType tActType = tActDoc.addNewTerminateActivities();
        tActType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        TerminateActivitiesResponseDocument trmRes = this.factory.TerminateActivities(tActDoc);
        return trmRes.getTerminateActivitiesResponse();
    }

    public GetFactoryAttributesDocumentResponseDocument getFactoryAttributesDocument(GetFactoryAttributesDocumentDocument1 req) throws Exception {
        return this.factory.GetFactoryAttributesDocument(req);
    }

    public GetFactoryAttributesDocumentResponseDocument getFactoryAttributesDocument() {
        try {
            GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
            req.addNewGetFactoryAttributesDocument();
            GetFactoryAttributesDocumentResponseDocument res = this.factory.GetFactoryAttributesDocument(req);
            return res;
        }
        catch (BaseFault e) {
            logger.error((Object)"Couldn't get the bes factory attributes.", (Throwable)e);
            return null;
        }
    }

    public FactoryResourceAttributesDocumentDocument1 getFactoryResourceAttributes() throws Exception {
        GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
        req.addNewGetFactoryAttributesDocument().set(ActivityUtils.filterNoneBeans());
        FactoryResourceAttributesDocumentDocument1 fres = FactoryResourceAttributesDocumentDocument1.Factory.newInstance();
        fres.addNewFactoryResourceAttributesDocument();
        fres.setFactoryResourceAttributesDocument(this.getFactoryAttributesDocument(req).getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument());
        return fres;
    }

    public GetActivityDocumentsResponseDocument getActivityDocuments(GetActivityDocumentsDocument req) throws UnknownActivityIdentifierFault {
        GetActivityDocumentsResponseDocument res = this.factory.GetActivityDocuments(req);
        return res;
    }

    public UpdateResourcePropertiesResponseDocument updateResourceProperties(UpdateResourcePropertiesDocument req) {
        UpdateResourcePropertiesResponseDocument res = null;
        try {
            res = this.factory.UpdateResourceProperties(req);
            return res;
        }
        catch (ResourceUnknownFault e) {
            logger.error((Object)"Unable to update resource, resource unknown", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            logger.error((Object)"Unable to update resource, resource unavailable", (Throwable)e);
        }
        catch (BaseFault e) {
            logger.error((Object)"Unable to update resource", (Throwable)e);
        }
        return null;
    }

    public ActivityStateEnumeration.Enum getActivityStatus(EndpointReferenceType eprt) {
        GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
        GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
        gStatsType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        GetActivityStatusesResponseDocument gResDoc = null;
        try {
            gResDoc = this.factory.GetActivityStatuses(gStatsDoc);
            ActivityStateEnumeration.Enum status = gResDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus().getState();
            return status;
        }
        catch (UnknownActivityIdentifierFault e) {
            logger.error((Object)"Couldn't get status.", (Throwable)((Object)e));
            return null;
        }
    }

    public String getActivityStatusAsXML(EndpointReferenceType eprt) {
        GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
        GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
        gStatsType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        GetActivityStatusesResponseDocument gResDoc = null;
        try {
            gResDoc = this.factory.GetActivityStatuses(gStatsDoc);
            return gResDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus().toString();
        }
        catch (UnknownActivityIdentifierFault e) {
            logger.error((Object)"Couldn't get status.", (Throwable)((Object)e));
            return null;
        }
    }

    public Long getTotalNumberOfActivities() throws Exception {
        long num = this.getFactoryResourceAttributes().getFactoryResourceAttributesDocument().getTotalNumberOfActivities();
        return num;
    }

    public String waitWhileActivityIsDone(EndpointReferenceType activityEpr, int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getActivityStatus(activityEpr);
            if (status == ActivityStateEnumeration.FINISHED) break;
            if (status == ActivityStateEnumeration.FAILED) {
                throw new Exception("Job failed");
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public String waitWhileActivityIsReady(EndpointReferenceType activityEpr, int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getActivityStatus(activityEpr);
            if (status.equals(ActivityStateEnumeration.RUNNING)) break;
            if (status.equals(ActivityStateEnumeration.FAILED) || status.equals(ActivityStateEnumeration.FINISHED)) {
                throw new Exception("Job is already done, status is <" + status.toString() + ">");
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }
}

