/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.client;

import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.unigrids.services.atomic.types.StatusInfoDocument;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.unigrids.x2006.x04.services.jms.WorkingDirectoryReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ActivityClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger((String)"unicore.client", ActivityClient.class);
    private final ResumeDocument resumeDoc;
    private final HoldDocument holdDoc;
    private final AbortDocument abortDoc;
    private final StartDocument startDoc;
    private Calendar submissionTime;
    private final BESActivity activity = (BESActivity)this.makeProxy(BESActivity.class);

    public ActivityClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        this.holdDoc = HoldDocument.Factory.newInstance();
        this.holdDoc.addNewHold();
        this.abortDoc = AbortDocument.Factory.newInstance();
        this.abortDoc.addNewAbort();
        this.startDoc = StartDocument.Factory.newInstance();
        this.startDoc.addNewStart();
        this.resumeDoc = ResumeDocument.Factory.newInstance();
        this.resumeDoc.addNewResume();
    }

    public void start() throws Exception {
        logger.info((Object)("Calling service at wsaTo: " + this.epr.getAddress().getStringValue()));
        this.activity.Start(this.startDoc);
    }

    public void abort() throws Exception {
        logger.debug((Object)("Calling service at wsaTo: " + this.epr.getAddress().getStringValue()));
        this.activity.Abort(this.abortDoc);
    }

    public void hold() throws Exception {
        logger.debug((Object)("Calling service at wsaTo: " + this.epr.getAddress().getStringValue()));
        this.activity.Hold(this.holdDoc);
    }

    public void resume() throws Exception {
        logger.debug((Object)("Calling service at wsaTo: " + this.epr.getAddress().getStringValue()));
        this.activity.Resume(this.resumeDoc);
    }

    public String waitUntilDone(int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (status == ActivityStateEnumeration.FINISHED || status == ActivityStateEnumeration.FAILED) break;
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public String waitUntilReady(int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (status.equals(ActivityStateEnumeration.RUNNING)) break;
            if (status.equals(ActivityStateEnumeration.FAILED) || status.equals(ActivityStateEnumeration.FINISHED)) {
                throw new Exception("Job is already done, status is <" + status.toString() + ">");
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public ActivityStateEnumeration.Enum getStatus() throws Exception {
        return ActivityStatusDocument.Factory.parse((String)this.getResourceProperty(BESActivity.RPStatus)).getActivityStatus().getState();
    }

    public Integer getExitCode() throws Exception {
        BigInteger exitCode = StatusInfoDocument.Factory.parse((String)this.getResourceProperty(JobManagement.RPStatusInfo)).getStatusInfo().getExitCode();
        return exitCode != null ? Integer.valueOf(exitCode.intValue()) : null;
    }

    public Calendar getSubmissionTime() throws Exception {
        if (this.submissionTime == null) {
            this.submissionTime = SubmissionTimeDocument.Factory.parse((String)this.getResourceProperty(JobManagement.RPSubmissionTime)).getSubmissionTime();
        }
        return this.submissionTime;
    }

    public StorageClient getUspaceClient() throws Exception {
        String address = this.getResourceProperty(JobManagement.RPWorkingDir);
        WorkingDirectoryReferenceDocument uEpr = WorkingDirectoryReferenceDocument.Factory.parse((String)address);
        StorageClient storageClient = new StorageClient(uEpr.getWorkingDirectoryReference(), this.getSecurityConfiguration());
        return storageClient;
    }
}

