/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsapi.xmlbeans;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.ApplicationStatus;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributePermission;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.ModificationEvent;
import pl.edu.icm.unicore.uvos.api.Notification;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import xmlbeans.pl.edu.icm.uvos.internal.AttributeDocument;
import xmlbeans.pl.edu.icm.uvos.internal.AttributePermissionXType;
import xmlbeans.pl.edu.icm.uvos.internal.AttributeXType;
import xmlbeans.pl.edu.icm.uvos.internal.AttributesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.AttributesListType;
import xmlbeans.pl.edu.icm.uvos.internal.ElementDocument;
import xmlbeans.pl.edu.icm.uvos.internal.ElementXType;
import xmlbeans.pl.edu.icm.uvos.internal.ElementsListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.ElementsListType;
import xmlbeans.pl.edu.icm.uvos.internal.GroupDocument;
import xmlbeans.pl.edu.icm.uvos.internal.GroupXType;
import xmlbeans.pl.edu.icm.uvos.internal.GroupsListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.GroupsListType;
import xmlbeans.pl.edu.icm.uvos.internal.IdentitiesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentitiesListType;
import xmlbeans.pl.edu.icm.uvos.internal.IdentityDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentityXType;
import xmlbeans.pl.edu.icm.uvos.internal.ModificationEventListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.ModificationEventListXType;
import xmlbeans.pl.edu.icm.uvos.internal.ModificationEventXType;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationDocument;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationListXType;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationXType;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDesignatorDocument;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDesignatorXType;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDocument;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsXType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormConstraintsType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormListType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationListType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationRequestsType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationType;

public class XMLBeansMapper {
    public static final String CHARSET = "UTF-8";

    public static Group map2APIGroup(GroupDocument xmlGroupDoc) {
        return XMLBeansMapper.map2APIGroup(xmlGroupDoc.getGroup());
    }

    public static Group map2APIGroup(GroupXType xmlGroup) {
        return new Group(xmlGroup.getPathArray(), XMLBeansMapper.c2d(xmlGroup.getCreationTS()), XMLBeansMapper.c2d(xmlGroup.getRemovalTS()));
    }

    public static GroupDocument map2XMLGroupDoc(Group group) {
        GroupDocument ret = GroupDocument.Factory.newInstance();
        ret.setGroup(XMLBeansMapper.map2XMLGroup(group));
        return ret;
    }

    public static GroupXType map2XMLGroup(Group group) {
        GroupXType gt = GroupXType.Factory.newInstance();
        if (group == null) {
            return gt;
        }
        gt.setPathArray(group.getPath());
        gt.setCreationTS(XMLBeansMapper.d2c(group.getCreationTS()));
        gt.setRemovalTS(XMLBeansMapper.d2c(group.getRemovalTS()));
        return gt;
    }

    public static Identity map2APIIdentity(IdentityDocument xmlIdDoc) {
        return XMLBeansMapper.map2APIIdentity(xmlIdDoc.getIdentity());
    }

    public static Identity map2APIIdentity(IdentityXType xmlId) {
        IdentityType idT = new IdentityType(xmlId.getType());
        Identity ret = new Identity(idT, new String(xmlId.getValue()), xmlId.getLabel(), xmlId.getPersistentId(), XMLBeansMapper.c2d(xmlId.getCreationTS()), XMLBeansMapper.c2d(xmlId.getRemovalTS()));
        ret.setAuthnData(xmlId.getAuthnData());
        if (xmlId.isSetInactive()) {
            ret.setInactive(xmlId.getInactive());
        }
        return ret;
    }

    public static IdentityDocument map2XMLIdentityDoc(Identity id) {
        IdentityDocument ret = IdentityDocument.Factory.newInstance();
        ret.setIdentity(XMLBeansMapper.map2XMLIdentity(id));
        return ret;
    }

    public static IdentityXType map2XMLIdentity(Identity id) {
        IdentityXType ret = IdentityXType.Factory.newInstance();
        ret.setType(id.getType().toString());
        ret.setLabel(id.getLabel());
        ret.setValue(id.getValue().getBytes());
        if (id.getAuthnData() != null) {
            ret.setAuthnData(id.getAuthnData().toString());
        }
        if (id.getPersistentEntityId() != null) {
            ret.setPersistentId(id.getPersistentEntityId());
        }
        ret.setInactive(id.isInactive());
        ret.setCreationTS(XMLBeansMapper.d2c(id.getCreationTS()));
        ret.setRemovalTS(XMLBeansMapper.d2c(id.getRemovalTS()));
        return ret;
    }

    public static Element map2APIElement(ElementDocument xmlElDoc) {
        return XMLBeansMapper.map2APIElement(xmlElDoc.getElement());
    }

    public static Element map2APIElement(ElementXType xmlEl) {
        IdentityXType xmlId;
        Identity id = null;
        Group g = null;
        GroupXType xmlG = xmlEl.getGroup();
        if (xmlG != null) {
            g = XMLBeansMapper.map2APIGroup(xmlG);
        }
        if ((xmlId = xmlEl.getId()) != null) {
            id = XMLBeansMapper.map2APIIdentity(xmlId);
        }
        return new Element(g, id);
    }

    public static ElementDocument map2XMLElementDoc(Element el) {
        ElementDocument ret = ElementDocument.Factory.newInstance();
        ret.setElement(XMLBeansMapper.map2XMLElement(el));
        return ret;
    }

    public static ElementXType map2XMLElement(Element el) {
        ElementXType ret = ElementXType.Factory.newInstance();
        if (el.getGroup() != null) {
            ret.setGroup(XMLBeansMapper.map2XMLGroup(el.getGroup()));
        }
        if (el.getIdentity() != null) {
            ret.setId(XMLBeansMapper.map2XMLIdentity(el.getIdentity()));
        }
        return ret;
    }

    public static Attribute map2APIAttribute(AttributeDocument xmlAttrDoc) throws XmlException {
        return XMLBeansMapper.map2APIAttribute(xmlAttrDoc.getAttribute());
    }

    public static Attribute map2APIAttribute(AttributeXType xmlAttr) throws XmlException {
        AttributeType at = new AttributeType(xmlAttr.getName(), xmlAttr.getShortDescription(), xmlAttr.getDescription());
        byte[][] byteVals = xmlAttr.getValueArray();
        if (byteVals != null) {
            Charset utfCharset = Charset.forName(CHARSET);
            ArrayList<String> vals = new ArrayList<String>();
            for (int i = 0; i < byteVals.length; ++i) {
                if (byteVals[i] == null) {
                    throw new XmlException("Can't parse attribute's" + xmlAttr.getName() + " value as a Base64 value.");
                }
                ByteBuffer bb = ByteBuffer.wrap(byteVals[i]);
                CharBuffer cb = utfCharset.decode(bb);
                vals.add(new String(cb.array(), cb.arrayOffset(), cb.limit() - cb.arrayOffset()));
            }
            return new Attribute(at, vals, xmlAttr.getScope(), XMLBeansMapper.c2d(xmlAttr.getCreationTS()), XMLBeansMapper.c2d(xmlAttr.getRemovalTS()));
        }
        return new Attribute(at, null, xmlAttr.getScope(), XMLBeansMapper.c2d(xmlAttr.getCreationTS()), XMLBeansMapper.c2d(xmlAttr.getRemovalTS()));
    }

    public static AttributeType map2APIAttributeType(AttributeXType xmlAttr) {
        return new AttributeType(xmlAttr.getName(), xmlAttr.getShortDescription(), xmlAttr.getDescription());
    }

    public static AttributeDocument map2XMLAttributeDoc(Attribute attr) {
        AttributeDocument ret = AttributeDocument.Factory.newInstance();
        ret.setAttribute(XMLBeansMapper.map2XMLAttribute(attr));
        return ret;
    }

    public static AttributeXType map2XMLAttribute(AttributeType attr) {
        AttributeXType ret = AttributeXType.Factory.newInstance();
        ret.setName(attr.getName());
        ret.setDescription(attr.getDescription());
        ret.setShortDescription(attr.getShortDescription());
        return ret;
    }

    public static AttributeXType map2XMLAttribute(Attribute attr) {
        AttributeXType ret = AttributeXType.Factory.newInstance();
        ret.setName(attr.getName().toString());
        ret.setDescription(attr.getType().getDescription());
        ret.setShortDescription(attr.getType().getShortDescription());
        List<String> vals = attr.getValues();
        Charset utfCharset = Charset.forName(CHARSET);
        if (vals != null) {
            byte[][] byteVals = new byte[vals.size()][];
            for (int i = 0; i < byteVals.length; ++i) {
                ByteBuffer bb = utfCharset.encode(vals.get(i));
                byteVals[i] = new byte[bb.remaining()];
                bb.get(byteVals[i]);
            }
            ret.setValueArray(byteVals);
        }
        if (attr.getScope() != null) {
            ret.setScope(attr.getScope());
        }
        ret.setCreationTS(XMLBeansMapper.d2c(attr.getCreationTS()));
        ret.setRemovalTS(XMLBeansMapper.d2c(attr.getRemovalTS()));
        return ret;
    }

    public static Permissions map2APIPermissions(PermissionsXType xmlPerms) {
        if (!xmlPerms.isSetValue()) {
            return null;
        }
        return new Permissions(xmlPerms.getValue());
    }

    public static PermissionsDocument map2XMLPermissionsDoc(Permissions perms) {
        PermissionsDocument ret = PermissionsDocument.Factory.newInstance();
        ret.setPermissions(XMLBeansMapper.map2XMLPermissions(perms));
        return ret;
    }

    public static PermissionsXType map2XMLPermissions(Permissions perms) {
        PermissionsXType ret = PermissionsXType.Factory.newInstance();
        if (perms != null) {
            ret.setValue(perms.getValue());
        }
        return ret;
    }

    public static PermissionDesignator map2APIDesignator(PermissionsDesignatorXType xmlPD) throws XmlException {
        String type = xmlPD.getType();
        if (type.equals(PermissionDesignator.SpecialDesignator.MEMBER.name()) || type.equals(PermissionDesignator.SpecialDesignator.OWNER.name())) {
            return new PermissionDesignator(PermissionDesignator.SpecialDesignator.valueOf(type));
        }
        return new PermissionDesignator(XMLBeansMapper.map2APIAttribute(xmlPD.getAttribute()));
    }

    public static PermissionsDesignatorDocument map2XMLDesignatorDoc(PermissionDesignator pd) {
        PermissionsDesignatorDocument ret = PermissionsDesignatorDocument.Factory.newInstance();
        ret.setPermissionsDesignator(XMLBeansMapper.map2XMLDesignator(pd));
        return ret;
    }

    public static PermissionsDesignatorXType map2XMLDesignator(PermissionDesignator pd) {
        PermissionsDesignatorXType ret = PermissionsDesignatorXType.Factory.newInstance();
        if (pd.isSpecial()) {
            ret.setType(pd.getSpecial().name());
        } else {
            ret.setType("Attribute");
            ret.setAttribute(XMLBeansMapper.map2XMLAttribute(pd.getAttribute()));
        }
        return ret;
    }

    public static AttributePermission map2APIAttrPerm(AttributePermissionXType xmlAP) throws XmlException {
        return new AttributePermission(XMLBeansMapper.map2APIDesignator(xmlAP.getDesignator()), XMLBeansMapper.map2APIPermissions(xmlAP.getPermission()));
    }

    public static AttributePermissionXType map2XMLAttrPerm(AttributePermission ap) {
        AttributePermissionXType ret = AttributePermissionXType.Factory.newInstance();
        ret.setDesignator(XMLBeansMapper.map2XMLDesignator(ap.getDesignator()));
        ret.setPermission(XMLBeansMapper.map2XMLPermissions(ap.getPermission()));
        return ret;
    }

    public static AttributesListDocument map2XMLAttributesList(List<Attribute> al) {
        AttributesListDocument retDoc = AttributesListDocument.Factory.newInstance();
        AttributesListType ret = retDoc.addNewAttributesList();
        AttributeXType[] array = new AttributeXType[al.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLAttribute(al.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static AttributesListDocument map2XMLAttributesListAt(List<AttributeType> al) {
        AttributesListDocument retDoc = AttributesListDocument.Factory.newInstance();
        AttributesListType ret = retDoc.addNewAttributesList();
        AttributeXType[] array = new AttributeXType[al.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLAttribute(al.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static List<AttributeType> map2APIAttributeTypesList(AttributesListDocument xmlAlDoc) {
        ArrayList<AttributeType> ret = new ArrayList<AttributeType>();
        AttributeXType[] xmlAl = xmlAlDoc.getAttributesList().getElementArray();
        for (int i = 0; i < xmlAl.length; ++i) {
            ret.add(XMLBeansMapper.map2APIAttributeType(xmlAl[i]));
        }
        return ret;
    }

    public static IdentitiesListDocument map2XMLIdentitiesList(List<Identity> al) {
        IdentitiesListDocument retDoc = IdentitiesListDocument.Factory.newInstance();
        IdentitiesListType ret = retDoc.addNewIdentitiesList();
        IdentityXType[] array = new IdentityXType[al.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLIdentity(al.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static GroupsListDocument map2XMLList(List<Group> al) {
        GroupsListDocument retDoc = GroupsListDocument.Factory.newInstance();
        GroupsListType ret = retDoc.addNewGroupsList();
        GroupXType[] array = new GroupXType[al.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLGroup(al.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static ElementsListDocument map2XMLElementsList(List<Element> al) {
        ElementsListDocument retDoc = ElementsListDocument.Factory.newInstance();
        ElementsListType ret = retDoc.addNewElementsList();
        ElementXType[] array = new ElementXType[al.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLElement(al.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static ModificationEventXType map2XMLModificationEventXType(ModificationEvent raw) {
        ModificationEventXType ret = ModificationEventXType.Factory.newInstance();
        ret.setCategory(raw.getCategory().toString());
        ret.setTimestamp(XMLBeansMapper.d2c(raw.getTimestamp()));
        ret.setType(raw.getType().toString());
        if (raw.getDescription() != null) {
            ret.setDescription(raw.getDescription());
        }
        return ret;
    }

    public static ModificationEventListDocument map2XMLModificationEventList(List<ModificationEvent> raw) {
        ModificationEventListDocument retDoc = ModificationEventListDocument.Factory.newInstance();
        ModificationEventListXType ret = retDoc.addNewModificationEventList();
        ModificationEventXType[] array = new ModificationEventXType[raw.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLModificationEventXType(raw.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static ModificationEvent map2APIModificationEvent(ModificationEventXType raw) {
        ModificationEvent ret = new ModificationEvent(XMLBeansMapper.c2d(raw.getTimestamp()), ModificationEvent.CATEGORY.valueOf(raw.getCategory()), ModificationEvent.TYPE.valueOf(raw.getType()));
        if (raw.isSetDescription()) {
            ret.setDescription(raw.getDescription());
        }
        return ret;
    }

    public static VOApplicationForm map2APIVOApplicationForm(VOApplicationFormDocument xmlDoc) {
        return XMLBeansMapper.map2APIVOApplicationForm(xmlDoc.getVOApplicationForm());
    }

    public static VOApplicationForm map2APIVOApplicationForm(VOApplicationFormType xml) {
        Group g = XMLBeansMapper.map2APIGroup(xml.getBaseGroup());
        VOApplicationForm ret = new VOApplicationForm(xml.getFriendlyName(), xml.getDescription(), xml.getId(), xml.getAgreement(), g, xml.getConstraints().xmlText());
        return ret;
    }

    public static VOApplicationFormDocument map2XMLVOApplicationFormDoc(VOApplicationForm raw) throws XmlException {
        Group g = raw.getBaseGroup();
        VOApplicationFormConstraintsType c = VOApplicationFormConstraintsType.Factory.parse(raw.getConstraints());
        VOApplicationFormDocument retDoc = VOApplicationFormDocument.Factory.newInstance();
        VOApplicationFormType ret = retDoc.addNewVOApplicationForm();
        ret.setAgreement(raw.getAgreement());
        ret.setBaseGroup(XMLBeansMapper.map2XMLGroup(g));
        ret.setDescription(raw.getDescription());
        ret.setFriendlyName(raw.getFriendlyName());
        ret.setId(raw.getId());
        ret.setConstraints(c);
        return retDoc;
    }

    public static VOApplicationFormType map2XMLVOApplicationForm(VOApplicationForm raw) throws XmlException {
        return XMLBeansMapper.map2XMLVOApplicationFormDoc(raw).getVOApplicationForm();
    }

    public static VOApplicationFormListDocument map2XMLVOApplicationFormList(List<VOApplicationForm> raw) throws XmlException {
        VOApplicationFormListDocument retDoc = VOApplicationFormListDocument.Factory.newInstance();
        VOApplicationFormListType ret = retDoc.addNewVOApplicationFormList();
        VOApplicationFormType[] array = new VOApplicationFormType[raw.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLVOApplicationForm(raw.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static List<VOApplicationForm> map2APIVOApplicationFormList(VOApplicationFormListDocument raw) {
        ArrayList<VOApplicationForm> ret = new ArrayList<VOApplicationForm>();
        VOApplicationFormType[] array = raw.getVOApplicationFormList().getElementArray();
        for (int i = 0; i < array.length; ++i) {
            ret.add(XMLBeansMapper.map2APIVOApplicationForm(array[i]));
        }
        return ret;
    }

    public static VOApplication map2APIVOApplication(VOApplicationType xml) {
        Identity id = XMLBeansMapper.map2APIIdentity(xml.getIdentity());
        Identity equivalent = null;
        if (xml.isSetEquivalentIdentity()) {
            equivalent = XMLBeansMapper.map2APIIdentity(xml.getEquivalentIdentity());
        }
        ApplicationStatus status = null;
        if (xml.getStatus() != null) {
            status = ApplicationStatus.valueOf(xml.getStatus());
        }
        VOApplication ret = new VOApplication(xml.getId(), xml.getFormId(), id, xml.getIsCSR(), xml.getContactEmail(), xml.getRequests().xmlText(), equivalent, status, xml.getAdminNotes());
        return ret;
    }

    public static VOApplication map2APIVOApplication(VOApplicationDocument xmlDoc) {
        return XMLBeansMapper.map2APIVOApplication(xmlDoc.getVOApplication());
    }

    public static VOApplicationDocument map2XMLVOApplicationDoc(VOApplication application) throws XmlException {
        VOApplicationDocument retDoc = VOApplicationDocument.Factory.newInstance();
        VOApplicationType ret = retDoc.addNewVOApplication();
        ret.setFormId(application.getFormId());
        ret.setId(application.getId());
        ret.setIdentity(XMLBeansMapper.map2XMLIdentity(application.getIdentity()));
        ret.setIsCSR(application.isCSR());
        ret.setContactEmail(application.getEmailAddress());
        if (application.getAdminNotes() != null) {
            ret.setAdminNotes(application.getAdminNotes());
        }
        if (application.getStatus() != null) {
            ret.setStatus(application.getStatus().toString());
        }
        if (application.getEquivalentIdentity() != null) {
            ret.setEquivalentIdentity(XMLBeansMapper.map2XMLIdentity(application.getEquivalentIdentity()));
        }
        VOApplicationRequestsType req = VOApplicationRequestsType.Factory.parse(application.getRequests());
        ret.setRequests(req);
        return retDoc;
    }

    public static VOApplicationType map2XMLVOApplication(VOApplication application) throws XmlException {
        return XMLBeansMapper.map2XMLVOApplicationDoc(application).getVOApplication();
    }

    public static List<VOApplication> map2APIVOApplicationList(VOApplicationListDocument raw) {
        ArrayList<VOApplication> ret = new ArrayList<VOApplication>();
        VOApplicationType[] array = raw.getVOApplicationList().getElementArray();
        for (int i = 0; i < array.length; ++i) {
            ret.add(XMLBeansMapper.map2APIVOApplication(array[i]));
        }
        return ret;
    }

    public static VOApplicationListDocument map2XMLVOApplicationList(List<VOApplication> raw) throws XmlException {
        VOApplicationListDocument retDoc = VOApplicationListDocument.Factory.newInstance();
        VOApplicationListType ret = retDoc.addNewVOApplicationList();
        VOApplicationType[] array = new VOApplicationType[raw.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLVOApplication(raw.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static Notification map2APINotification(NotificationXType xml) {
        return new Notification(xml.getId(), xml.getGroupFilter(), xml.getRecipients(), xml.getAction());
    }

    public static Notification map2APINotification(NotificationDocument xmlDoc) {
        return XMLBeansMapper.map2APINotification(xmlDoc.getNotification());
    }

    public static NotificationDocument map2XMLNotificationDoc(Notification notification) {
        NotificationDocument retDoc = NotificationDocument.Factory.newInstance();
        NotificationXType ret = retDoc.addNewNotification();
        ret.setAction(notification.getOperation());
        if (notification.getGroupFilter() != null) {
            ret.setGroupFilter(notification.getGroupFilter());
        }
        ret.setId(notification.getId());
        ret.setRecipients(notification.getRecipients());
        return retDoc;
    }

    public static NotificationXType map2XMLNotification(Notification notification) {
        return XMLBeansMapper.map2XMLNotificationDoc(notification).getNotification();
    }

    public static List<Notification> map2APINotificationList(NotificationListDocument raw) {
        ArrayList<Notification> ret = new ArrayList<Notification>();
        NotificationXType[] array = raw.getNotificationList().getElementArray();
        for (int i = 0; i < array.length; ++i) {
            ret.add(XMLBeansMapper.map2APINotification(array[i]));
        }
        return ret;
    }

    public static NotificationListDocument map2XMLNotificationsList(List<Notification> raw) {
        NotificationListDocument retDoc = NotificationListDocument.Factory.newInstance();
        NotificationListXType ret = retDoc.addNewNotificationList();
        NotificationXType[] array = new NotificationXType[raw.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLBeansMapper.map2XMLNotification(raw.get(i));
        }
        ret.setElementArray(array);
        return retDoc;
    }

    public static Date c2d(Calendar c) {
        return c == null ? null : new Date(c.getTimeInMillis());
    }

    public static Calendar d2c(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }
}

