/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsapi.xmlbeans;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;

public class SAMLDefaultAttributeProfile
implements SAMLAttributeProfile {
    @Override
    public int isSupported(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) {
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        if (xmlVals == null || xmlVals.length == 0) {
            return 0;
        }
        if (xmlVals[0] instanceof XmlString) {
            return 0;
        }
        return -1;
    }

    @Override
    public List<Attribute> map(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) throws UnsupportedSAMLException, SAMLParseException {
        AttributeType at = new AttributeType(xmlAttr.getName());
        String shortDesc = xmlAttr.getFriendlyName();
        if (shortDesc != null) {
            at.setShortDescription(shortDesc);
        }
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        XmlCursor cur = xmlAttr.newCursor();
        String xacmlDT = cur.getAttributeText(SAMLConstants.XACMLDT);
        cur.dispose();
        if (xacmlDT != null) {
            at.setDataType(xacmlDT);
        }
        if (xmlVals == null || xmlVals.length == 0) {
            ret.add(new Attribute(at, null, null));
            return ret;
        }
        HashMap<String, Integer> attrMap = new HashMap<String, Integer>();
        for (int i = 0; i < xmlVals.length; ++i) {
            Attribute tmp = this.mapAttrValue2APIAttr(at, xmlVals[i]);
            Integer idx = (Integer)attrMap.get(tmp.getScope());
            if (idx == null) {
                attrMap.put(tmp.getScope(), ret.size());
                ret.add(tmp);
                continue;
            }
            Attribute existingA = ret.get(idx);
            if (tmp.getValues().size() <= 0) continue;
            existingA.addValue(tmp.getValues().get(0));
        }
        return ret;
    }

    private Attribute mapAttrValue2APIAttr(AttributeType at, XmlObject value) throws UnsupportedSAMLException, SAMLParseException {
        ArrayList<String> values = new ArrayList<String>();
        if (!(value instanceof XmlString)) {
            throw new UnsupportedSAMLException("Unknown type of attribute value received for DefaultSAMLProfile, likely its a BUG, value " + value.xmlText());
        }
        values.add(((XmlString)value).getStringValue());
        return new Attribute(at, values, null);
    }
}

