/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.idhelpers;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.security.auth.x500.X500Principal;
import org.apache.xmlbeans.impl.util.Base64;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.idhelpers.GenericIdentityHelper;

public class X509IdentityHelper
extends GenericIdentityHelper {
    private X509Certificate cert;

    public X509IdentityHelper(Identity id) throws InvalidValueException {
        super(id);
        try {
            X509Certificate[] certs = this.parse(this.identity.getValue());
            if (certs.length == 0) {
                throw new InvalidValueException("Certificate (chain) value is invalid: empty chain/certificate");
            }
            this.cert = certs[0];
        }
        catch (IOException e) {
            throw new InvalidValueException("Certificate (chain) value is invalid: " + e.getMessage());
        }
    }

    @Override
    public String generateUniqueLabel() {
        return "X509Certificate_" + X500NameUtils.getComparableForm((String)this.cert.getIssuerX500Principal().getName());
    }

    @Override
    public String getComparableValue() {
        String ret = X500NameUtils.getComparableForm((String)this.cert.getIssuerX500Principal().getName()) + "###" + this.cert.getSerialNumber() + "###" + this.cert.hashCode();
        return ret;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    private X509Certificate[] parse(String value) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(value.getBytes("US-ASCII"));
        return CertificateUtils.loadCertificateChain((InputStream)bais, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
    }

    public static PKCS10CertificationRequest parseCSR(String csr) throws SignatureException, NoSuchAlgorithmException, IOException {
        csr = csr.replace("\n", "");
        Pattern p = Pattern.compile("-----[^-]*-----");
        String[] parts = p.split(csr);
        csr = parts[1];
        return new PKCS10CertificationRequest(Base64.decode((byte[])csr.getBytes()));
    }

    public static Identity convertCert(X509Certificate cert) throws IOException {
        String id;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CertificateUtils.saveCertificate((OutputStream)baos, (X509Certificate)cert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        try {
            id = baos.toString("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JDK is misconfigured, US-ASCII charset is not supported?!", e);
        }
        return new Identity(IdentityType.X509CERT, id, null);
    }

    @Override
    public String toPrettyString() {
        return "[X.509 Cert.] Subject's DN: " + this.toPrettyStringNoPrefix();
    }

    @Override
    public String toPrettyStringNoPrefix() {
        return X500NameUtils.getReadableForm((X500Principal)this.cert.getSubjectX500Principal());
    }

    @Override
    public List<Attribute> generateAttributes() {
        try {
            return this.generateAttributesFromDN(this.cert.getSubjectX500Principal().getName());
        }
        catch (InvalidNameException e) {
            return new ArrayList<Attribute>();
        }
    }
}

