/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.security;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.unicore.security.xfireutil.client.Configurable;
import eu.unicore.security.xfireutil.client.DSigOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProxyCertOutHandler
extends AbstractHandler
implements Configurable {
    private static final Logger logger = Log.getLogger((String)"unicore.security", ProxyCertOutHandler.class);
    protected IClientConfiguration sec;
    private Element proxyHeaderAsJDOM = null;
    public static final String PROXY_LIFETIME = "unicore.proxy.lifetime";
    public static final String PROXY_KEYSIZE = "unicore.proxy.keysize";
    public static final String PROXY_FILE = "unicore.proxy.file";
    private long expiryInstant;
    private String pem;

    public ProxyCertOutHandler() {
        this.setPhase("post-invoke");
        this.before(DSigOutHandler.class.getName());
    }

    public synchronized void configure(IClientConfiguration sec) {
        this.sec = sec;
        this.pem = null;
        try {
            this.pem = sec.getExtraSettings().getProperty(PROXY_FILE) != null ? this.readProxyFromFile(sec.getExtraSettings().getProperty(PROXY_FILE)) : this.generateProxy();
            StringBuilder sb = new StringBuilder();
            sb.append("<proxy:Proxy xmlns:proxy=\"http://www.unicore.eu/unicore6\">");
            sb.append(this.pem);
            sb.append("</proxy:Proxy>");
            this.proxyHeaderAsJDOM = new SAXBuilder().build((InputStream)new ByteArrayInputStream(sb.toString().getBytes())).detachRootElement();
        }
        catch (Exception ce) {
            logger.error((Object)"Can't create Proxy header: ", (Throwable)ce);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"(Re-)initialised Proxy Outhandler");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                new XMLOutputter(Format.getPrettyFormat()).output(this.proxyHeaderAsJDOM, (OutputStream)bos);
                logger.debug((Object)bos.toString());
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
    }

    protected String readProxyFromFile(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        try {
            KeyStore ks = CertificateUtils.loadPEMKeystore((InputStream)is, (char[])null, (char[])"none".toCharArray());
            X509Certificate x509 = (X509Certificate)ks.getCertificate("default");
            logger.info((Object)("Read proxy from '" + fileName + "' valid till " + x509.getNotAfter()));
            this.expiryInstant = x509.getNotAfter().getTime() - 21600000L;
            String string = FileUtils.readFileToString((File)new File(fileName));
            return string;
        }
        catch (KeyStoreException ex) {
            throw new IOException(ex);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    protected String generateProxy() throws Exception {
        String keysizeP;
        X509Credential credential = this.sec.getCredential();
        ProxyCertificateOptions param = new ProxyCertificateOptions(credential.getCertificateChain());
        String lifetimeP = this.sec.getExtraSettings().getProperty(PROXY_LIFETIME);
        if (lifetimeP != null) {
            param.setLifetime(Integer.parseInt(lifetimeP));
        }
        if ((keysizeP = this.sec.getExtraSettings().getProperty(PROXY_KEYSIZE)) != null) {
            param.setKeyLength(Integer.parseInt(keysizeP));
        }
        ProxyCertificate proxy = ProxyGenerator.generate((ProxyCertificateOptions)param, (PrivateKey)credential.getKey());
        int lifetime = param.getLifetime();
        this.expiryInstant = proxy.getCertificateChain()[0].getNotAfter().getTime() - (long)(lifetime / 2 * 1000);
        ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
        OutputStreamWriter ow = new OutputStreamWriter(os);
        PEMWriter pw = new PEMWriter((Writer)ow);
        pw.writeObject((Object)proxy.getCertificateChain()[0]);
        pw.writeObject((Object)proxy.getPrivateKey());
        pw.writeObject((Object)credential.getCertificate());
        pw.flush();
        ow.close();
        return os.toString("US-ASCII");
    }

    public Element getProxyHeader() {
        return this.proxyHeaderAsJDOM;
    }

    public synchronized void invoke(MessageContext context) throws Exception {
        if (this.proxyHeaderAsJDOM == null) {
            return;
        }
        Boolean clientMode = (Boolean)context.getProperty("client.mode");
        if (clientMode == null || !clientMode.booleanValue()) {
            return;
        }
        if (System.currentTimeMillis() > this.expiryInstant) {
            this.configure(this.sec);
        }
        Element h = context.getOutMessage().getOrCreateHeader();
        h.addContent((Content)((Element)this.proxyHeaderAsJDOM.clone()));
    }

    String getPem() {
        return this.pem;
    }
}

