/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.rns;

import de.fzj.unicore.uas.rns.FilterFactory;
import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.RNSFault;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RNSPath
implements Serializable,
Cloneable {
    private static final Logger logger = Log.getLogger((String)"unicore.client", RNSPath.class);
    public static final int DONT_CARE = 0;
    public static final int MUST_EXIST = 1;
    public static final int MUST_NOT_EXIST = 2;
    private RNSPath parent;
    private String name;
    private EndpointReferenceType cachedEPR;

    public EndpointReferenceType getEndpointReference() throws RNSEntryDoesNotExistFault {
        return this.resolveRequired();
    }

    private EndpointReferenceType resolveRequired() throws RNSEntryDoesNotExistFault {
        EndpointReferenceType epr = this.resolveOptional();
        if (epr == null) {
            throw new RNSEntryDoesNotExistFault(this.toString());
        }
        return epr;
    }

    private EndpointReferenceType resolveOptional() {
        return null;
    }

    public RNSPath(RNSPath parent, String nameFromParent, EndpointReferenceType cachedEPR) {
        this.parent = parent;
        this.name = nameFromParent;
        this.cachedEPR = cachedEPR;
        if (parent == null && nameFromParent != null || parent != null && nameFromParent == null) {
            throw new IllegalArgumentException("The parent and the nameFromParent parameters must either both be null, or both be non-null.");
        }
        if (parent == null && cachedEPR == null) {
            throw new IllegalArgumentException("Cannot have a null EPR for the root.");
        }
    }

    public RNSPath(EndpointReferenceType root) {
        this(null, null, root);
    }

    public String getName() {
        if (this.name == null) {
            return "/";
        }
        return this.name;
    }

    public String toString() {
        if (this.parent == null) {
            return "/";
        }
        String s = this.parent.toString();
        if (s == "/") {
            return s + this.name;
        }
        return s + "/" + this.name;
    }

    public boolean equals(RNSPath other) {
        if (other instanceof RNSPath) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public RNSPath getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public RNSPath getParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean exists() {
        return this.resolveOptional() != null;
    }

    public void mkdir() throws RNSEntryDoesNotExistFault, RNSEntryExistsFault, RNSFault {
        if (this.exists()) {
            throw new RNSEntryExistsFault(this.toString());
        }
        if (this.parent == null) {
            throw new RNSFault("Someone tried to create the root directory, which can't be done.");
        }
        EndpointReferenceType parentEndpoint = this.parent.resolveRequired();
    }

    public void mkdirs() throws RNSEntryDoesNotExistFault, RNSEntryExistsFault, RNSFault {
        if (this.exists()) {
            throw new RNSEntryExistsFault(this.toString());
        }
        if (this.parent == null) {
            throw new RNSFault("Someone tried to create the root directory, which can't be done.");
        }
        if (!this.parent.exists()) {
            this.parent.mkdirs();
        }
        this.mkdir();
    }

    public EndpointReferenceType createNewFile() throws RNSEntryExistsFault, RNSEntryDoesNotExistFault, RNSFault {
        throw new RNSFault("Unable to create new file: NOT IMPLEMENTED");
    }

    private void arrayify(ArrayList<RNSPath> rep) {
        if (this.parent != null) {
            this.parent.arrayify(rep);
        }
        rep.add(this);
    }

    public RNSPath lookup(String path) {
        try {
            return this.lookup(path, 0);
        }
        catch (RNSEntryDoesNotExistFault rpdnee) {
            logger.error((Object)"This exception shouldn't have happened.", (Throwable)((Object)rpdnee));
        }
        catch (RNSEntryExistsFault rpdnee) {
            logger.error((Object)"This exception shouldn't have happened.", (Throwable)((Object)rpdnee));
        }
        return null;
    }

    private static String formPath(String[] pathElements) {
        StringBuilder builder = new StringBuilder();
        for (String element : pathElements) {
            builder.append(String.format("/%s", element));
        }
        if (builder.length() == 0) {
            builder.append("/");
        }
        return builder.toString();
    }

    public RNSPath lookup(String path, int queryFlag) throws RNSEntryDoesNotExistFault, RNSEntryExistsFault {
        int lcv;
        if (path == null) {
            throw new IllegalArgumentException("Cannot lookup a path which is null.");
        }
        String[] pathElements = RNSPath.normalizePath(this.toString(), path);
        String fullPath = RNSPath.formPath(pathElements);
        RNSPath ret = null;
        ArrayList<RNSPath> arrayRep = new ArrayList<RNSPath>();
        this.arrayify(arrayRep);
        for (lcv = 0; lcv < pathElements.length && lcv + 1 < arrayRep.size() && pathElements[lcv].equals(arrayRep.get((int)(lcv + 1)).name); ++lcv) {
        }
        if (lcv >= pathElements.length) {
            ret = arrayRep.get(lcv);
            return ret;
        }
        RNSPath next = arrayRep.get(lcv);
        while (lcv < pathElements.length) {
            ++lcv;
        }
        if (RNSPath.isFlagSet(queryFlag, 1)) {
            if (!next.exists()) {
                throw new RNSEntryDoesNotExistFault(next.toString());
            }
        } else if (RNSPath.isFlagSet(queryFlag, 2) && next.exists()) {
            throw new RNSEntryExistsFault(next.toString());
        }
        return next;
    }

    public static boolean isFlagSet(int value, int flag) {
        return (flag & value) != 0;
    }

    public static String[] normalizePath(String currentPath, String path) {
        String fullPath = path.startsWith("/") ? path : currentPath + "/" + path;
        return RNSPath.normalizePath(fullPath);
    }

    public static String[] normalizePath(String path) {
        String[] ret;
        Stack<String> nPath = new Stack<String>();
        for (String s : ret = path.split("/")) {
            if (s == null || s.length() == 0) continue;
            if (s.equals("..")) {
                if (nPath.empty()) continue;
                nPath.pop();
                continue;
            }
            if (s.equals(".")) continue;
            nPath.push(s);
        }
        ret = new String[nPath.size()];
        nPath.toArray(ret);
        return ret;
    }

    private Collection<RNSPath> expand(RNSPath parent, String[] pathElements, int nextElement, FilterFactory filterType) {
        LinkedList<RNSPath> ret = new LinkedList<RNSPath>();
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public Collection<RNSPath> expand(String pathExpression) {
        return null;
    }

    public Collection<RNSPath> listContents() throws RNSEntryDoesNotExistFault, RNSFault {
        throw new RNSFault("NOT IMPLEMENTED");
    }

    public void link(EndpointReferenceType epr) throws RNSEntryExistsFault, RNSEntryDoesNotExistFault, RNSFault {
    }

    public void unlink() throws RNSEntryDoesNotExistFault, RNSFault {
    }

    public void delete() throws RNSEntryDoesNotExistFault, RNSFault {
    }
}

