/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.CoreClientCapabilities;
import de.fzj.unicore.uas.FiletransferParameterProvider;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.client.BaseClientWithStatus;
import de.fzj.unicore.uas.client.Configurable;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.IGridFileFilter;
import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.SByteIOClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.wsrflite.ClientCapabilities;
import de.fzj.unicore.wsrflite.ClientCapability;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.PermissionsType;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.services.atomic.types.ProtocolDocument;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ChangeACLEntryType;
import org.unigrids.x2006.x04.services.sms.ChangeACLType;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsDocument;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsEntryType;
import org.unigrids.x2006.x04.services.sms.CopyDocument;
import org.unigrids.x2006.x04.services.sms.CreateDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.DeleteDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.ExtendedChangePermissionsType;
import org.unigrids.x2006.x04.services.sms.ExtraParametersDocument;
import org.unigrids.x2006.x04.services.sms.FilterType;
import org.unigrids.x2006.x04.services.sms.FindDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.ListDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.ListPropertiesDocument;
import org.unigrids.x2006.x04.services.sms.PermissionsChangeModeType;
import org.unigrids.x2006.x04.services.sms.PermissionsClassType;
import org.unigrids.x2006.x04.services.sms.ReceiveFileDocument;
import org.unigrids.x2006.x04.services.sms.ReceiveFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.RenameDocument;
import org.unigrids.x2006.x04.services.sms.SendFileDocument;
import org.unigrids.x2006.x04.services.sms.SendFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.StoragePropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageClient
extends BaseClientWithStatus {
    private final StorageManagement sms = (StorageManagement)this.makeProxy(StorageManagement.class);
    public static final QName RPProtocol = ProtocolDocument.type.getDocumentElementName();
    public static QName RPFileSystem = FileSystemDocument.type.getDocumentElementName();
    protected static final Map<ProtocolType.Enum, Class<? extends FileTransferClient>> registeredClients = new HashMap<ProtocolType.Enum, Class<? extends FileTransferClient>>();
    private static ServiceLoader<FiletransferParameterProvider> parameterProviders = null;

    public static synchronized void registerClient(ProtocolType.Enum proto, Class<? extends FileTransferClient> clazz) {
        StorageClient.registerClient(proto.toString(), clazz);
    }

    public static synchronized void registerClient(String proto, Class<? extends FileTransferClient> clazz) {
        StorageClient.initRegisteredClients();
        StorageClient.doRegister(proto, clazz);
    }

    private static void doRegister(String proto, Class<? extends FileTransferClient> clazz) {
        registeredClients.put(ProtocolType.Enum.forString((String)proto), clazz);
    }

    public StorageClient(String url, EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        super(url, address, sec);
        StorageClient.initRegisteredClients();
        this.setRetryDefaults();
    }

    public StorageClient(EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        this(address.getAddress().getStringValue(), address, sec);
    }

    public StoragePropertiesDocument getResourcePropertiesDocument() throws Exception {
        return StoragePropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public String getStorageName() throws Exception {
        return this.getFileSystem().getName();
    }

    public long getAvailableSpace() throws Exception {
        RangeValueType diskSpace = this.getFileSystem().getDiskSpace();
        return diskSpace != null ? (long)diskSpace.getExactArray()[0].getDoubleValue() : -1L;
    }

    public FileSystemType getFileSystem() throws Exception {
        return this.getResourcePropertiesDocument().getStorageProperties().getFileSystem();
    }

    public GridFileType[] listDirectory(String path) throws BaseFault {
        ListDirectoryDocument req = ListDirectoryDocument.Factory.newInstance();
        req.addNewListDirectory().setPath(path);
        return this.sms.ListDirectory(req).getListDirectoryResponse().getGridFileArray();
    }

    public GridFileType listProperties(String path) throws BaseFault, FileNotFoundException {
        ListPropertiesDocument req = ListPropertiesDocument.Factory.newInstance();
        req.addNewListProperties().setPath(path);
        GridFileType res = this.sms.ListProperties(req).getListPropertiesResponse().getGridFile();
        if (res == null) {
            throw new FileNotFoundException("Path <" + path + "> not found on storage.");
        }
        return res;
    }

    public boolean supportsMetadata() throws Exception {
        return this.getResourcePropertiesDocument().getStorageProperties().getMetadataServiceReference() != null;
    }

    public boolean supportsACL() throws Exception {
        return this.getResourcePropertiesDocument().getStorageProperties().isSetACLSupported() && this.getResourcePropertiesDocument().getStorageProperties().getACLSupported();
    }

    public MetadataClient getMetadataClient() throws ClientException, Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getStorageProperties().getMetadataServiceReference();
        if (epr == null) {
            throw new ClientException("This service does not support metadata management --- please check using the supportsMetadata() method.");
        }
        return new MetadataClient(epr, this.getSecurityConfiguration());
    }

    public void changePermissions(String path, boolean read, boolean write, boolean execute) throws BaseFault {
        ChangePermissionsDocument req = ChangePermissionsDocument.Factory.newInstance();
        req.addNewChangePermissions().setPath(path);
        PermissionsType permissions = PermissionsType.Factory.newInstance();
        permissions.setReadable(read);
        permissions.setWritable(write);
        permissions.setExecutable(execute);
        req.getChangePermissions().setPermissions(permissions);
        this.sms.ChangePermissions(req);
    }

    public void changePermissions2(String path, PermissionsChangeModeType.Enum mode, PermissionsClassType.Enum permClass, String rwxPermissions, boolean recursive) throws BaseFault {
        ChangePermissionsDocument reqDoc = ChangePermissionsDocument.Factory.newInstance();
        ChangePermissionsDocument.ChangePermissions req = reqDoc.addNewChangePermissions();
        req.setPath(path);
        ExtendedChangePermissionsType chmod = req.addNewExtendedPermissions();
        ChangePermissionsEntryType chmodE = chmod.addNewChangePermissionsEntry();
        chmodE.setKind(permClass);
        chmodE.setMode(mode);
        chmodE.setPermissions(rwxPermissions);
        req.setRecursive(recursive);
        this.sms.ChangePermissions(reqDoc);
    }

    public void chgrp(String path, String group, boolean recursive) throws BaseFault {
        ChangePermissionsDocument reqDoc = ChangePermissionsDocument.Factory.newInstance();
        ChangePermissionsDocument.ChangePermissions req = reqDoc.addNewChangePermissions();
        req.setPath(path);
        req.setChangeOwningGroup(group);
        req.setRecursive(recursive);
        this.sms.ChangePermissions(reqDoc);
    }

    public void setACL(String path, boolean clearAll, ChangeACLEntryType[] aces, boolean recursive) throws BaseFault {
        ChangePermissionsDocument reqDoc = ChangePermissionsDocument.Factory.newInstance();
        ChangePermissionsDocument.ChangePermissions req = reqDoc.addNewChangePermissions();
        req.setPath(path);
        ChangeACLType acl = ChangeACLType.Factory.newInstance();
        if (aces != null) {
            acl.setChangeACLEntryArray(aces);
        }
        acl.setClearACL(clearAll);
        req.setACL(acl);
        req.setRecursive(recursive);
        this.sms.ChangePermissions(reqDoc);
    }

    public void ChangePermissions(String path, ChangePermissionsDocument reqDoc) throws BaseFault {
        this.sms.ChangePermissions(reqDoc);
    }

    public GridFileType[] find(String base, boolean recurse, String nameMatch, boolean regexp, Calendar before, Calendar after) throws BaseFault {
        FindDocument req = FindDocument.Factory.newInstance();
        req.addNewFind().setBase(base);
        req.getFind().setRecurse(recurse);
        FilterType filter = FilterType.Factory.newInstance();
        if (regexp) {
            filter.setNameMatchRegExp(nameMatch);
        } else {
            filter.setNameMatch(nameMatch);
        }
        filter.setBefore(before);
        filter.setAfter(after);
        req.getFind().setFilter(filter);
        return this.sms.Find(req).getFindResponse().getGridFileArray();
    }

    public void copy(String source, String destination) throws BaseFault {
        CopyDocument in = CopyDocument.Factory.newInstance();
        in.addNewCopy().setSource(source);
        in.getCopy().setDestination(destination);
        this.sms.Copy(in);
    }

    public void delete(String path) throws BaseFault {
        DeleteDocument in = DeleteDocument.Factory.newInstance();
        in.addNewDelete().setPath(path);
        this.sms.Delete(in);
    }

    public void rename(String source, String destination) throws BaseFault {
        RenameDocument in = RenameDocument.Factory.newInstance();
        in.addNewRename().setSource(source);
        in.getRename().setDestination(destination);
        this.sms.Rename(in);
    }

    public ImportFileResponseDocument ImportFile(ImportFileDocument in) throws Exception {
        return this.sms.ImportFile(in);
    }

    public ExportFileResponseDocument ExportFile(ExportFileDocument in) throws BaseFault {
        return this.sms.ExportFile(in);
    }

    public ReceiveFileResponseDocument ReceiveFile(ReceiveFileDocument in) throws BaseFault {
        return this.sms.ReceiveFile(in);
    }

    public SendFileResponseDocument SendFile(SendFileDocument in) throws BaseFault {
        return this.sms.SendFile(in);
    }

    public TransferControllerClient fetchFile(String source, String destination, Map<String, String> extraParameters) throws Exception {
        return this.fetchFile(source, destination, extraParameters, false);
    }

    public TransferControllerClient fetchFile(String source, String destination, Map<String, String> extraParameters, boolean reliableMode) throws Exception {
        ReceiveFileDocument in = ReceiveFileDocument.Factory.newInstance();
        in.addNewReceiveFile().setDestination(destination);
        in.getReceiveFile().setSource(source);
        in.getReceiveFile().setExtraParameters(StorageClient.makeExtraParameters(extraParameters, null));
        in.getReceiveFile().setReliableMode(reliableMode);
        EndpointReferenceType epr = this.ReceiveFile(in).getReceiveFileResponse().getReceiveFileEPR();
        TransferControllerClient c = new TransferControllerClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
        return c;
    }

    public TransferControllerClient fetchFile(String source, String destination) throws Exception {
        return this.fetchFile(source, destination, null);
    }

    public TransferControllerClient sendFile(String source, String destination, Map<String, String> extraParameters) throws Exception {
        SendFileDocument in = SendFileDocument.Factory.newInstance();
        in.addNewSendFile().setDestination(destination);
        in.getSendFile().setSource(source);
        in.getSendFile().setExtraParameters(StorageClient.makeExtraParameters(extraParameters, null));
        EndpointReferenceType epr = this.SendFile(in).getSendFileResponse().getSendFileEPR();
        TransferControllerClient c = new TransferControllerClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
        return c;
    }

    public TransferControllerClient sendFile(String source, String destination) throws Exception {
        return this.sendFile(source, destination, null);
    }

    public void createDirectory(String path) throws BaseFault {
        CreateDirectoryDocument in = CreateDirectoryDocument.Factory.newInstance();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        in.addNewCreateDirectory().setPath(path);
        this.sms.CreateDirectory(in);
    }

    public FileTransferClient getExport(String path, ProtocolType.Enum protocol, Map<String, String> extraParameters) throws IOException {
        return this.getExport(path, extraParameters, protocol);
    }

    public FileTransferClient getExport(String path, ProtocolType.Enum ... preferredProtocols) throws IOException {
        return this.getExport(path, (Map<String, String>)null, preferredProtocols);
    }

    public FileTransferClient getExport(String path, Map<String, String> extraParameters, ProtocolType.Enum ... preferredProtocols) throws IOException {
        ProtocolType.Enum protocol = this.findSupportedProtocol(preferredProtocols);
        if (protocol == null) {
            throw new IOException("None of the file transfer protocols " + Arrays.asList(preferredProtocols) + " is supported by the storage!");
        }
        Class<? extends FileTransferClient> clazz = registeredClients.get(protocol);
        if (clazz == null) {
            throw new IOException("No matching client class supporting the <" + protocol + "> protocol found.");
        }
        EndpointReferenceType ftEpr = null;
        try {
            ExportFileDocument efd = ExportFileDocument.Factory.newInstance();
            ExportFileDocument.ExportFile export = efd.addNewExportFile();
            export.setIsPipe(false);
            export.setProtocol(protocol);
            export.setSource(path);
            export.setExtraParameters(StorageClient.makeExtraParameters(extraParameters, String.valueOf(protocol)));
            ftEpr = this.ExportFile(efd).getExportFileResponse().getExportEPR();
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Can't create export.", (Throwable)e);
            throw new IOException(msg, e);
        }
        try {
            String url = ftEpr.getAddress().getStringValue();
            FileTransferClient fts = clazz.getConstructor(String.class, EndpointReferenceType.class, IClientConfiguration.class).newInstance(url, ftEpr, this.getSecurityConfiguration());
            if (fts instanceof Configurable) {
                ((Configurable)((Object)fts)).configure(extraParameters);
            }
            return fts;
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)("Can't instantiate export client for protocol <" + protocol + ">"), (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    public RByteIOClient getExport(String path) throws IOException {
        return (RByteIOClient)this.getExport(path, ProtocolType.RBYTEIO);
    }

    public SByteIOClient getReadStream(String path) throws IOException {
        return (SByteIOClient)this.getExport(path, ProtocolType.SBYTEIO);
    }

    public SByteIOClient getWriteStream(String path) throws IOException {
        return (SByteIOClient)this.getImport(path, ProtocolType.SBYTEIO);
    }

    public ProtocolType.Enum[] getSupportedProtocols() throws Exception {
        return this.getResourcePropertiesDocument().getStorageProperties().getProtocolArray();
    }

    public static void download(URI uri, IClientConfiguration sec, OutputStream writeTo) throws Exception {
        ProtocolType.Enum protocol = ProtocolType.Enum.forString((String)uri.getScheme());
        String storageUrl = uri.getSchemeSpecificPart();
        String relativePath = uri.getFragment();
        EndpointReferenceType storageEpr = EndpointReferenceType.Factory.newInstance();
        storageEpr.addNewAddress().setStringValue(storageUrl);
        StorageClient storageClient = new StorageClient(storageUrl, storageEpr, sec);
        FileTransferClient ftc = storageClient.getExport(relativePath, protocol);
        ftc.readAllData(writeTo);
        writeTo.flush();
    }

    public FileTransferClient getImport(String path, boolean append, Map<String, String> extraParameters, ProtocolType.Enum ... protocols) throws IOException {
        ProtocolType.Enum proto = this.findSupportedProtocol(protocols);
        if (proto == null) {
            throw new IOException("None of the file transfer protocols " + Arrays.asList(protocols) + " is supported by the storage!");
        }
        Class<? extends FileTransferClient> clazz = registeredClients.get(proto);
        if (clazz == null) {
            throw new IOException("No matching client class supporting the <" + proto + "> protocol found.");
        }
        EndpointReferenceType ftEpr = null;
        try {
            ImportFileDocument ifd = ImportFileDocument.Factory.newInstance();
            ImportFileDocument.ImportFile in = ifd.addNewImportFile();
            in.setIsPipe(false);
            in.setProtocol(proto);
            in.setOverwrite(!append);
            in.setDestination(path);
            in.setExtraParameters(StorageClient.makeExtraParameters(extraParameters, String.valueOf(proto)));
            ftEpr = this.ImportFile(ifd).getImportFileResponse().getImportEPR();
            String url = ftEpr.getAddress().getStringValue();
            FileTransferClient fts = clazz.getConstructor(String.class, EndpointReferenceType.class, IClientConfiguration.class).newInstance(url, ftEpr, this.getSecurityConfiguration());
            fts.setAppend(append);
            if (fts instanceof Configurable) {
                ((Configurable)((Object)fts)).configure(extraParameters);
            }
            return fts;
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)"Can't create import.", (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    public FileTransferClient getImport(String path, boolean append, ProtocolType.Enum proto, Map<String, String> extraParameters) throws IOException {
        return this.getImport(path, append, extraParameters, proto);
    }

    public FileTransferClient getImport(String path, ProtocolType.Enum ... preferredProtocols) throws IOException {
        return this.getImport(path, false, null, preferredProtocols);
    }

    public RByteIOClient getImport(String path) throws IOException {
        return (RByteIOClient)this.getImport(path, ProtocolType.RBYTEIO);
    }

    public EnumerationClient<EndpointReferenceDocument> getFiletransferEnumeration() throws Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getStorageProperties().getFiletransferEnumerationReference();
        if (epr != null) {
            EnumerationClient<EndpointReferenceDocument> c = new EnumerationClient<EndpointReferenceDocument>(epr, this.getSecurityConfiguration(), EndpointReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExtraParametersDocument.ExtraParameters makeExtraParameters(Map<String, String> params, String protocol) {
        Class<StorageClient> clazz = StorageClient.class;
        synchronized (StorageClient.class) {
            if (parameterProviders == null) {
                parameterProviders = ServiceLoader.load(FiletransferParameterProvider.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (params == null) {
                params = new HashMap<String, String>();
            }
            for (FiletransferParameterProvider f : parameterProviders) {
                f.provideParameters(params, protocol);
            }
            ExtraParametersDocument.ExtraParameters r = ExtraParametersDocument.ExtraParameters.Factory.newInstance();
            if (params != null) {
                for (Map.Entry<String, String> e : params.entrySet()) {
                    PropertyType t = r.addNewParameter();
                    t.setName(e.getKey());
                    t.setValue(e.getValue());
                }
            }
            return r;
        }
    }

    public ProtocolType.Enum findSupportedProtocol(ProtocolType.Enum ... preferredProtocols) throws IOException {
        try {
            for (ProtocolType.Enum p : preferredProtocols) {
                for (ProtocolType.Enum test : this.getSupportedProtocols()) {
                    if (!test.equals(p)) continue;
                    return p;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Can't get protocols.", e);
        }
        return null;
    }

    public GridFileType[] find(String topFolder, IGridFileFilter filter) throws BaseFault {
        List<GridFileType> list;
        GridFileType[] retval = null;
        if (topFolder == null || "".equals(topFolder) || filter == null) {
            return retval;
        }
        if ("/".equals(topFolder)) {
            list = this.recursiveFind(topFolder, filter);
        } else {
            filter.setCriteria(topFolder + filter.getInitCriteria());
            list = this.recursiveFind(topFolder, filter);
        }
        retval = new GridFileType[list.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = list.get(i);
        }
        return retval;
    }

    private List<GridFileType> recursiveFind(String topFolder, IGridFileFilter filter) throws BaseFault {
        int i;
        GridFileType[] childs = null;
        ArrayList<GridFileType> collect = new ArrayList<GridFileType>();
        ArrayList<GridFileType> subfolders = new ArrayList<GridFileType>();
        try {
            childs = this.listDirectory(topFolder);
        }
        catch (BaseFault ignored) {
            // empty catch block
        }
        if (childs == null) {
            return collect;
        }
        for (i = 0; i < childs.length; ++i) {
            if (childs[i].getIsDirectory()) {
                subfolders.add(childs[i]);
            }
            if (!filter.match(childs[i])) continue;
            collect.add(childs[i]);
        }
        for (i = 0; i < subfolders.size(); ++i) {
            if (!filter.browseSubfolder((GridFileType)subfolders.get(i))) continue;
            String subFolder = ((GridFileType)subfolders.get(i)).getPath();
            collect.addAll(this.recursiveFind(subFolder, filter));
        }
        return collect;
    }

    private static synchronized void initRegisteredClients() {
        if (registeredClients.size() == 0) {
            ServiceLoader<ClientCapabilities> sl = ServiceLoader.load(ClientCapabilities.class);
            Iterator<ClientCapabilities> iter = sl.iterator();
            while (iter.hasNext()) {
                ClientCapability[] cs = iter.next().getClientCapabilities();
                for (int j = 0; j < cs.length; ++j) {
                    ClientCapability c = cs[j];
                    if (!(c instanceof CoreClientCapabilities.FTClientCapability)) continue;
                    CoreClientCapabilities.FTClientCapability ftc = (CoreClientCapabilities.FTClientCapability)c;
                    StorageClient.doRegister(ftc.getProtocol(), ftc.getImplementation());
                }
            }
        }
    }
}

