/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.log4j.Logger;

public class HttpBasicClient
implements FiletransferOptions.Read,
FiletransferOptions.Write,
FiletransferOptions.IMonitorable,
FiletransferOptions.SupportsPartialRead {
    private static final Logger logger = Log.getLogger((String)"unicore.client", HttpBasicClient.class);
    private final String accessURL;
    private final IClientConfiguration sec;
    private Long totalBytesTransferred = 0L;
    private ProgressListener<Long> observer;
    private boolean append = false;

    public HttpBasicClient(String url, IClientConfiguration sec) throws Exception {
        this.accessURL = url;
        this.sec = sec;
    }

    @Override
    public void readAllData(OutputStream os) throws Exception {
        HttpClient client = this.getClient();
        GetMethod get = new GetMethod(this.accessURL);
        this.totalBytesTransferred = this.read(os, get, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long read(OutputStream os, GetMethod get, HttpClient client) throws IOException {
        InputStream is = null;
        try {
            int result = client.executeMethod((HttpMethod)get);
            if (result < 200 || result > 299) {
                throw new IOException("Can't read remote data, server returned " + HttpStatus.getStatusText((int)result));
            }
            is = get.getResponseBodyAsStream();
            long l = this.copy(is, os);
            return l;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignored) {}
            get.releaseConnection();
        }
    }

    public void writeAllData(InputStream is, boolean append) throws Exception {
        this.append = append;
        this.writeAllData(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAllData(final InputStream is) throws Exception {
        HttpClient client = this.getClient();
        EntityEnclosingMethod upload = this.createMethodForUpload();
        InputStream decoratedStream = new InputStream(){

            @Override
            public int read() throws IOException {
                int b = is.read();
                if (b != -1) {
                    Long l = HttpBasicClient.this.totalBytesTransferred;
                    Long l2 = HttpBasicClient.this.totalBytesTransferred = HttpBasicClient.this.totalBytesTransferred + 1L;
                    if (HttpBasicClient.this.observer != null) {
                        HttpBasicClient.this.observer.notifyProgress(1L);
                        if (HttpBasicClient.this.observer.isCancelled()) {
                            throw new ProgressListener.CancelledException("Cancelled.");
                        }
                    }
                }
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int r = is.read(b, off, len);
                if (r > 0) {
                    HttpBasicClient.this.totalBytesTransferred = HttpBasicClient.this.totalBytesTransferred + (long)r;
                    if (HttpBasicClient.this.observer != null) {
                        HttpBasicClient.this.observer.notifyProgress(Long.valueOf(r));
                        if (HttpBasicClient.this.observer.isCancelled()) {
                            throw new ProgressListener.CancelledException("Cancelled.");
                        }
                    }
                }
                return r;
            }
        };
        upload.setRequestEntity((RequestEntity)new InputStreamRequestEntity(decoratedStream));
        this.totalBytesTransferred = 0L;
        try {
            int result = client.executeMethod((HttpMethod)upload);
            if (result < 200 || result > 299) {
                throw new IOException("Can't write data, server returned " + HttpStatus.getStatusText((int)result));
            }
            logger.debug((Object)("Total transferred bytes: " + this.totalBytesTransferred + ", HTTP return status " + upload.getStatusLine()));
        }
        finally {
            upload.releaseConnection();
        }
    }

    @Override
    public void writeAllData(InputStream source, long numBytes) throws Exception {
        if (numBytes < 0L) {
            this.writeAllData(source);
        } else {
            this.writeAllData((InputStream)new BoundedInputStream(source, numBytes));
        }
    }

    public String getAccessURL() {
        return this.accessURL;
    }

    @Override
    public long readPartial(long offset, long length, OutputStream os) throws IOException {
        HttpClient client = this.getClient();
        GetMethod get = new GetMethod(this.accessURL);
        get.addRequestHeader("Range", "bytes=" + offset + "-" + (offset + length - 1L));
        return this.read(os, get, client);
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 16384;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        int c = 0;
        long progress = 0L;
        long total = 0L;
        while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
            if (len <= 0) continue;
            out.write(buffer, 0, len);
            total += (long)len;
            progress += (long)len;
            if (++c % 10 != 0 || this.observer == null) continue;
            this.observer.notifyProgress(progress);
            if (this.observer.isCancelled()) {
                throw new ProgressListener.CancelledException("Cancelled.");
            }
            progress = 0L;
        }
        if (this.observer != null) {
            this.observer.notifyProgress(progress);
        }
        out.flush();
        return total;
    }

    protected HttpClient getClient() {
        HttpClient client = HttpUtils.createClient((String)this.accessURL, (IClientConfiguration)this.sec);
        return client;
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    @Override
    public void setProgressListener(ProgressListener<Long> o) {
        this.observer = o;
    }

    protected EntityEnclosingMethod createMethodForUpload() {
        return this.accessURL.contains("method=POST") ? this.createPost() : this.createPut();
    }

    protected EntityEnclosingMethod createPut() {
        PutMethod upload = new PutMethod(this.accessURL);
        upload.setContentChunked(true);
        if (this.append) {
            upload.addRequestHeader("X-UNICORE-AppendData", "true");
        }
        return upload;
    }

    protected EntityEnclosingMethod createPost() {
        PostMethod upload = new PostMethod(this.accessURL);
        upload.addRequestHeader("Content-Type", "multipart/form-data; boundary=--part-boundary--");
        upload.setContentChunked(true);
        if (this.append) {
            upload.addRequestHeader("X-UNICORE-AppendData", "true");
        }
        return upload;
    }
}

