/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.fts.FileTransfer;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.TargetDocument;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.services.atomic.types.ProtocolDocument;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.services.atomic.types.StorageEndpointReferenceDocument;
import org.unigrids.x2006.x04.services.fts.FileTransferPropertiesDocument;
import org.unigrids.x2006.x04.services.fts.SizeDocument;
import org.unigrids.x2006.x04.services.fts.StatusDocument;
import org.unigrids.x2006.x04.services.fts.SummaryType;
import org.unigrids.x2006.x04.services.fts.TransferredBytesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class FileTransferClient
extends BaseUASClient
implements FiletransferOptions.Read,
FiletransferOptions.Write {
    protected static final Logger logger = Log.getLogger((String)"unicore.client", FileTransferClient.class);
    protected boolean append = false;

    public FileTransferClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public FileTransferClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    @Override
    public void writeAllData(InputStream source, long numBytes) throws Exception {
        if (numBytes < 0L) {
            this.writeAllData(source);
        } else {
            this.writeAllData((InputStream)new BoundedInputStream(source, numBytes));
        }
    }

    public long getTransferredBytes() throws Exception {
        TransferredBytesDocument tbd = TransferredBytesDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPTransferred));
        return tbd.getTransferredBytes();
    }

    public EndpointReferenceType getParentStorage() throws Exception {
        StorageEndpointReferenceDocument ser = StorageEndpointReferenceDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPParentSMS));
        return ser.getStorageEndpointReference();
    }

    public ProtocolType.Enum getProtocol() throws Exception {
        ProtocolDocument pd = ProtocolDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPProtocol));
        return pd.getProtocol();
    }

    public String getSource() throws Exception {
        SourceDocument s = SourceDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPSource));
        return s.getSource().getURI();
    }

    public String getTarget() throws Exception {
        TargetDocument t = TargetDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPTarget));
        return t.getTarget().getURI();
    }

    public String getStatus() throws Exception {
        StatusDocument status = StatusDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPStatus));
        return status.getStatus().getSummary().toString() + " [" + status.getStatus().getDescription() + "]";
    }

    public SummaryType.Enum getStatusSummary() throws Exception {
        StatusDocument status = StatusDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPStatus));
        return status.getStatus().getSummary();
    }

    public long getSourceFileSize() {
        try {
            SizeDocument sd = SizeDocument.Factory.parse((String)this.getResourceProperty(FileTransfer.RPSize));
            return sd.getSize();
        }
        catch (Exception ex) {
            Log.logException((String)"Error getting size of remote file.", (Throwable)ex, (Logger)logger);
            return -1L;
        }
    }

    public FileTransferPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return FileTransferPropertiesDocument.Factory.parse((InputStream)this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public Map<String, String> getProtocolDependentRPs() throws Exception {
        PropertyType[] props;
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyType p : props = this.getResourcePropertiesDocument().getFileTransferProperties().getPropertyArray()) {
            if (p.getName() == null || p.getValue() == null) continue;
            result.put(p.getName(), p.getValue());
        }
        return result;
    }

    public static interface IMonitorable
    extends FiletransferOptions.IMonitorable {
    }

    public static interface SupportsPartialRead
    extends FiletransferOptions.SupportsPartialRead {
    }

    public static interface IChunked
    extends FiletransferOptions.IChunked {
    }
}

