/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ccm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class UniversalSocketFactory
implements SecureProtocolSocketFactory {
    private final SSLContext sslcontext;
    private final TrustManager[] trustManagers;

    public UniversalSocketFactory(TrustManager trustManager) throws KeyManagementException, NoSuchAlgorithmException {
        this.trustManagers = new TrustManager[]{trustManager};
        this.sslcontext = this.createSSLContext();
    }

    private SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] keymanagers = null;
        SSLContext sslcontext = SSLContext.getInstance("SSL");
        sslcontext.init(keymanagers, this.trustManagers, null);
        return sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.sslcontext.getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.sslcontext.getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.sslcontext.getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslcontext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

