/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ccm;

import eu.unicore.ccm.AcceptingTrustManager;
import eu.unicore.ccm.UniversalSocketFactory;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;
import xmlbeans.eu.unicore.ccm.internal.TrustedCAType;

public class ProfileHandler {
    public static final int BUF_SIZE = 102400;
    public static final int HTTP_TIMEOUT = 15000;
    private ClientProfileDocument.ClientProfile profile;

    public ProfileHandler(ClientProfileDocument.ClientProfile profile) {
        this.profile = profile;
    }

    private static GetMethod executeGet(String urlString) throws HttpException, IOException {
        HttpClient httpclient = new HttpClient();
        httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
        httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
        URL url = new URL(urlString);
        GetMethod httpget = null;
        if (url.getProtocol().equals("https")) {
            AcceptingTrustManager tm = new AcceptingTrustManager();
            try {
                Protocol myProtocol = new Protocol("https", (ProtocolSocketFactory)new UniversalSocketFactory(tm), url.getPort());
                httpclient.getHostConfiguration().setHost(url.getHost(), url.getPort(), myProtocol);
                httpget = new GetMethod(url.getPath());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            httpget = new GetMethod(urlString);
        }
        try {
            int statusCode = httpclient.executeMethod((HttpMethod)httpget);
            if (statusCode != 200) {
                throw new IOException("Can't download data from the URL " + urlString + " The error received from the server was: " + httpget.getStatusText());
            }
        }
        catch (IOException t) {
            httpget.releaseConnection();
            throw t;
        }
        catch (RuntimeException e) {
            httpget.releaseConnection();
            throw e;
        }
        return httpget;
    }

    private static void readFullyTo(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[102400];
        int read = 0;
        while ((read = is.read(buffer, 0, 102400)) != -1) {
            os.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadToFile(String urlString, String path) throws IOException {
        URL u = new URL(urlString);
        BufferedOutputStream os = null;
        InputStream is = null;
        GetMethod httpget = null;
        if (u.getProtocol().equals("file")) {
            is = u.openStream();
        } else {
            httpget = ProfileHandler.executeGet(urlString);
            is = httpget.getResponseBodyAsStream();
        }
        try {
            os = new BufferedOutputStream(new FileOutputStream(path));
            ProfileHandler.readFullyTo(is, os);
        }
        finally {
            if (httpget != null) {
                httpget.releaseConnection();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadToString(String url, int maxSize) throws HttpException, IOException {
        URL u = new URL(url);
        if (u.getProtocol().equals("file")) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream()));
            StringBuilder buf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
            br.close();
            return buf.toString();
        }
        GetMethod httpget = ProfileHandler.executeGet(url);
        try {
            String string = httpget.getResponseBodyAsString(maxSize);
            return string;
        }
        finally {
            httpget.releaseConnection();
        }
    }

    public static String extractPEMContents(String dirtyPEM) throws ParseException {
        Pattern starter = Pattern.compile("^---[-]+[^-]+---[-]+$", 8);
        Matcher m = starter.matcher(dirtyPEM);
        if (!m.find()) {
            throw new ParseException("The supplied data is not in PEM format, no starting line found.", dirtyPEM.length());
        }
        int start = m.end();
        String header = m.group();
        if (!m.find()) {
            throw new ParseException("The supplied data is not in PEM format, no ending line found.", dirtyPEM.length());
        }
        int end = m.start();
        String footer = m.group();
        String chopped = dirtyPEM.substring(start, end);
        String normalizedHeader = header.replaceFirst("---[-]+([^-]+)---[-]+", "-----$1-----");
        String normalizedFooter = footer.replaceFirst("---[-]+([^-]+)---[-]+", "-----$1-----");
        return normalizedHeader + chopped + normalizedFooter;
    }

    private static X509Certificate parse(String value) throws CertificateException {
        String cleaned;
        try {
            cleaned = ProfileHandler.extractPEMContents(value);
        }
        catch (ParseException e) {
            throw new CertificateException("Invalid input format", e);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(cleaned.getBytes());
        return (X509Certificate)factory.generateCertificate(bais);
    }

    public List<X509Certificate> downloadCACerts() throws IOException {
        TrustedCAType[] CAs = this.profile.getTrustedCAArray();
        if (CAs == null || CAs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        for (TrustedCAType ca : CAs) {
            String cert;
            String url = ca.getCertificateURL();
            try {
                cert = ProfileHandler.downloadToString(url, 102400);
            }
            catch (IOException e) {
                throw new IOException("Can't download certificate from " + ca.getCertificateURL(), e);
            }
            try {
                ret.add(ProfileHandler.parse(cert));
            }
            catch (CertificateException e) {
                throw new IOException("Certificate downloaded from " + ca.getCertificateURL() + " can not be parsed.", e);
            }
        }
        return ret;
    }
}

