/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ccm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class FingerprintTrustManager
implements X509TrustManager {
    private final String fingerprint;
    private final X509Certificate[] empty = new X509Certificate[0];
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public FingerprintTrustManager(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        throw new CertificateException("Tried to use " + FingerprintTrustManager.class.getName() + " on server side, while it is designed to be used on client side only.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates == null || certificates.length == 0) {
            throw new CertificateException("Didn't get any server certificate");
        }
        for (X509Certificate cert : certificates) {
            cert.checkValidity();
        }
        X509Certificate server = certificates[0];
        try {
            String real = FingerprintTrustManager.computeFingerprint(server);
            if (!real.equalsIgnoreCase(this.fingerprint)) {
                throw new CertificateException("The fingerprint of the server's certificate doesn't match the configured fingerprint.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("Can't compute fingrprint for a certificate", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.empty;
    }

    public static String computeFingerprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(cert.getEncoded());
        byte[] fp = md.digest();
        return FingerprintTrustManager.hexify(fp);
    }

    public static String hexify(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
            if (i >= bytes.length - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }
}

