/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ccm;

import eu.unicore.ccm.SSLFingerprintSocketFactory;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import xmlbeans.eu.unicore.ccm.internal.ClientProfileDocument;

public class CCMManager {
    private final int MAX_PROFILE = 1024000;
    public static final String INSTRUCTION_INTRO = "Using this utility you can download a configuration for your UNICORE client software.";
    public static final String INSTRUCTION_GENERIC = "The client's configuration is usually prepared and distributed by grid middleware providers. The configuration may be created for both production and tutorial or test installations. The data neccessary to fetch the configuration should be provided to you by your infrastructure provider: typically in support materials distributed in paper form or on on-line website";
    public static final String INSTRUCTION_SECURITY = "SECURITY WARNING: it is crucial to install the client's configuration only from the trusted source, as installation of a malicious configuration effectively makes your client insecure. Therefore you can only download the configuration from a server after providing its fingerprint code. However you must be especially careful from what source you get the fingerprint code: it should be provided to you from a trusted people directly (e.g. during a live tutorial) or distributed on a trusted web site, i.e. the web site providing the code should be accessed using https:// address and your browser SHOULD NOT display any security warnings when accessing it.";

    public ClientProfileDocument.ClientProfile download(String urlString, String fingerprint) throws IllegalArgumentException, IOException, XmlException, KeyManagementException, NoSuchAlgorithmException {
        String profile = this.downloadProfile(urlString, fingerprint);
        return CCMManager.parseProfileXML(profile);
    }

    public static ClientProfileDocument.ClientProfile parseProfileXML(String xml) throws XmlException {
        ClientProfileDocument profileDoc = ClientProfileDocument.Factory.parse(xml);
        ArrayList validationErrors = new ArrayList();
        XmlOptions voptions = new XmlOptions();
        voptions.setValidateTreatLaxAsSkip();
        voptions.setErrorListener(validationErrors);
        if (!profileDoc.validate(voptions)) {
            StringBuilder errors = new StringBuilder();
            for (Object o : validationErrors) {
                errors.append(o.toString());
                errors.append("\n");
            }
            throw new XmlException("Received document is invalid. Syntax errors found: \n" + errors);
        }
        return profileDoc.getClientProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadProfile(String urlString, String fingerprint) throws IllegalArgumentException, IOException, KeyManagementException, NoSuchAlgorithmException {
        String ret;
        URL url = new URL(urlString);
        if (!url.getProtocol().equals("https")) {
            throw new IllegalArgumentException("Configuration profiles can be downloaded only from https hosts.");
        }
        int port = url.getPort();
        if (port == -1) {
            port = 443;
        }
        Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new SSLFingerprintSocketFactory(fingerprint), port);
        HttpClient httpclient = new HttpClient();
        httpclient.getHostConfiguration().setHost(url.getHost(), port, myhttps);
        GetMethod httpget = new GetMethod(url.getPath());
        try {
            int statusCode = httpclient.executeMethod((HttpMethod)httpget);
            if (statusCode != 200) {
                throw new IOException("Can't download the profile from the HTTP server. The error received from the server was: " + httpget.getStatusText());
            }
            ret = httpget.getResponseBodyAsString(1024000);
        }
        finally {
            httpget.releaseConnection();
        }
        return ret;
    }
}

