package GetStatusListing;

###############################################################################
# UXP/V
#
#    developed on a VPP at fecit (tested) Sven van den Berghe
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

	my($command, $output, $result, $bssid, $state, $ustate, $result);

	debug_report("Finding all jobs on BSS");

	# Form the request command. 
	$command = "$main::qstat_cmd";

	command_report($command);

	$output = `($command) 2>&1`;

	# Parse output
	if($? != 0) {
	    failed_report($output);
	}
	else {
		# Command succeeded. Parse the output and return
		# a line for each job found with two words, the first
		# is the BSS id the second its _Unicore_ state

		# The output format of the lines we want is:
		# Request    1:  Name=start  Id=44167.vx4_pe000
		#                               ^^^^^
		#                               bss id
		#       Owner=marek  Priority=20  RUNNING  Job-ID=30530  Phase=<Running>
		#                                 ^^^^^^ 
		#                                 state 

		$result = "QSTAT\n";

		$_ = $output;
		#
		# Terms for match of first line are: start of a line
		#            anything up to "Id="
		#            an integer      <- keep, this is the BSS Id
		#            "." marks end of integer
		#            any amount of junk to end of line (to finish it)
		#
		#            Next line is read and third word picked out
		#
		# Note g to resume from end of last match
		while(/^.*Id=(\d+)\..*$/gm) {
			$bssid = $1;
			if(/\s*\S+\s*\S+\s*(\S+).*$/gm) {
				$state = $1;

				# Catches all known values, treats pipe queue states as queued as
				# they are intermediate and we do not know what will happen to the
				# on the destination queues.

				$ustate = "UNKNOWN";
				$ustate = "QUEUED"  if $state =~ /QUEUED|WAITING|ARRIVING|ROUTING|DEPARTING/;
				$ustate = "SUSPENDED"  if $state =~ /HOLDING/;
				$ustate = "RUNNING" if $state =~ /RUNNING|EXITING/ ;

                # can also report FROZEN if this is supported by BSS (held and resources released)

				# Add to the returned lines

				$result = "$result $bssid $ustate\n";
			}
		}

		print main::CMD_SOCK $result;
		debug_report("qstat executed OK");
	}

}
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
