package Initialisation;

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(initialisation);

use Socket;        
use Reporting qw(initial_report report_and_die);

use strict;

sub initialisation() {

    initial_report("TSI $main::my_version for $main::my_os ");
    initial_report("Copyright (c)  Fujitsu Ltd, 1999 to 2003. All Rights Reserved.\n");
    initial_report("Using Perl version $]");

    my $old_fh = select(STDOUT);
    $| = 1;
    select($old_fh);

    $old_fh = select(STDERR);
    $| = 1;
    select($old_fh);

    # --------------------------------------------------------------------
    # Where to contact the NJS. This information can come
    # from the command line (two arguments in order host_name, port)
    # or, failing that, from values in the initialisation section.
    #
    # In either case the NJS must be listening for TSI connections
    # on this port.
    # The NJS is told about TSIs in the IDB TSI description section
    # with the keyword PORT.

    my $njs_machine = $main::njs_machine;
    if ($njs_machine =~ m/(.*)/s ) {
        $njs_machine = $1;
    }

    my $njs_port    = $main::njs_port;
    if ($njs_port =~ m/(.*)/s ) {
        $njs_port = $1;
    }

    initial_report("Contacting the NJS on <$njs_machine> at port number <$njs_port>");

    # --------------------------------------------------------------------
    # Open a pair of sockets to the NJS, one to carry commands (text)
    # and the other to carry data (files read and written).
    #
    # This is boiler plate code adapted from Programming Perl p349
    #
    if($njs_port =~ /\D/) {$njs_port = getservbyname($njs_port, 'tcp')};
    report_and_die("No NJS port") unless $njs_port;

    my $iaddr = inet_aton($njs_machine);
    my $paddr = sockaddr_in($njs_port, $iaddr);

    my $proto = getprotobyname('tcp');

    # Open the commands channel, wait here for the NJS to start up

    socket(main::CMD_SOCK, PF_INET, SOCK_STREAM, $proto) or report_and_die("command socket: $!");
    while(! connect(main::CMD_SOCK, $paddr) ) {
        initial_report("Waiting for NJS at $njs_machine:$njs_port to come up (last connect attempt said: $!)");
        sleep 30;
        socket(main::CMD_SOCK, PF_INET, SOCK_STREAM, $proto) or report_and_die("command socket: $!");
    }

    # Open the data channel

    socket(main::DATA_SOCK, PF_INET, SOCK_STREAM, $proto) or report_and_die("data socket: $!");
    connect(main::DATA_SOCK, $paddr)                      or report_and_die("data connect: $!");

    # Ensure that output is flushed

    $old_fh = select(main::CMD_SOCK);
    $| = 1;
    select($old_fh);

    $old_fh = select(main::DATA_SOCK);
    $| = 1;
    select($old_fh);

    initial_report("Connection to NJS established.");
}
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
