package GetStatusListing; 

###############################################################################
# IRIX LSF 6.0
#
#
###############################################################################

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

use Reporting qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# IRIX LSF

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

    my($command, $output, $result, @lines, $bssid, $state, $ustate, $junk);

    debug_report("Finding all jobs on BSS");

    # Form the request command. 
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if($? != 0) {
	failed_report($output);
    }
    else {
	# Command succeeded. Parse the output and return
	# a line for each job found with two words, the first
	# is the job id the second its _Unicore_ state.

	# The output format of the interesting lines is:
	# xxxxxx user Status junk ..... junk
	#
	# Where xxxxx is the Job id to return, the number of
	# junk fields is variable and we interpret the first letter
	# of status (status may be absent!)
	#                                 state           job id
	# e.g.
	#
	# JOBID USER STAT QUEUE FROM_HOST EXEC_HOST JOB_NAME SUBMIT_TIME
	# 1652  bob  DONE normal gridnode1  gridnode3   date Jun 19 12:45
	# ^^^^^                                                                        ^
	#
	# There are also some uninteresting lines. 
	#
	# Do not differentiate between pipe and batch queues
	#
	# Ignore the minor states

	$result = "QSTAT\n";

	# @lines = split /\n/,$output; #for older LSF versions this might be the line to use...
	
	@lines = split / /,$output; # <-- /n deleted by SARA (walter@sara.nl) for LSF 6.0
	for(@lines) {
	    s/\s+/ /g;         # <-- added by SARA (walter@sara.nl) for LSF 6.0
	    SWITCH: {

		/\d+/ && do {
		    # Found a job running for Unicore
			($bssid,$junk,$state) = split / /,$_;


		    # Catches all known values.
		    # Absent statuses are treated as unknown as status will contain a number
		    $ustate = "UNKNOWN";

		    # A - arriving, queue has not processed, so not running
		    # D - departing, leaving pipe so not running
		    # Q - queued
		    # W - waiting (for date or pipe q available)
		    # $ustate = "QUEUED"  if $state =~ /A|D|Q|W/;
		    $ustate = "QUEUED"  if $state =~ /PEND/;
		    $ustate = "QUEUED"  if $state =~ /WAIT/;
		    $ustate = "QUEUED"  if $state =~ /ZOMBI/;

		    # E - exiting, finished execution but implicit output written?
		    # R - running (or ROUTING in pipe queue AAAARRRGGGGHH :-( )
		    # $ustate = "RUNNING" if $state =~ /R|E/ ;
		    $ustate = "RUNNING" if $state =~ /EXIT/ ;
		    $ustate = "RUNNING" if $state =~ /RUN/ ;

		    # C - checkpointed ?
		    # H - held
		    # P - preempted, assume that it will be automatically restarted
		    # S - suspended
		    # $ustate = "SUSPENDED" if $state =~ /C|H|P|S/ ;
		    $ustate = "SUSPENDED" if $state =~ /PSUSP/ ;
		    $ustate = "SUSPENDED" if $state =~ /USUSP/ ;
		    $ustate = "SUSPENDED" if $state =~ /SSUSP/ ;

		    # U - unknown

            # can also report FROZEN if this is supported by BSS (held and resources released)

		    # Add to the returned lines
		    $result = "$result $bssid $ustate\n";

		    last SWITCH;
		}
	    }
	}

	print main::CMD_SOCK $result;
	debug_report("qstat executed OK");
    }
}
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
