package GetStatusListing;            # SPECIALISATION FOR HP-UX

require Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(get_status_listing);

#use Reporting qw(start_report failed_report ok_report debug_report);
use Reporting qw(debug_report failed_report ok_report start_report command_report report_and_die);

use strict;

# Queries the BSS for the state of (at least) all Unicore jobs
# and returns a list of their identifier together with the
# stats.
#
# Called in response to a #TSI_JOBQUERY in the script

# uses functions from Reporting

# No args
#
# Returns void to TSI
#         fail/success to NJS and a list of jobs
#
#        First line is "QSTAT",
#        followed by a line per found job, first word is BSS job identifier
#        and the second word is one of RUNNING, QUEUED or SUSPENDED or FROZEN
#
#        List must include all Unicore jobs (but can contain  extra jobs)
#
sub get_status_listing {

     my($command, $output, $result, $bssid, @lines, $junk, $bssid, $state, $data, $ustate);

    debug_report("Finding all jobs from Unicore");

    # Get all the processes on the system, with sufficient information
    # to be able to derive the Unicore ones

    # Form the request command. 
    $command = "$main::qstat_cmd";

    command_report($command);

    $output = `($command) 2>&1`;

    # Parse output
    if($? != 0) {
         failed_report($output);
    }
    else {
        # Command succeeded. Parse the output and return
        # a line for each job found with two words, the first
        # is the job id the second its _Unicore_ state
        # ----------------------------------
        # NQS 3.3.0.15 BATCH REQUEST SUMMARY
        # ----------------------------------
        # IDENTIFIER    NAME    USER     LOCATION/QUEUE        JID  PRTY REQMEM REQTIM ST
        # ------------- ------- -------- --------------------- ---- ---- ------ ------ ---
        # 264.hp50.ep-ksa.mbag.str.daimler-benz.com FD75as1f xr08332  ExxxxxxAThwwo2k        451185  --- 5120000 360000 R  
        # 423.w0009024.pcd.daimler-benz.com FD75sk8 chriso   ep4gb8cpuAThwwo2k      454726  --- 4096000 3000000 R  
        # 423.w0009024.pcd.daimler-benz.com FD75sk8 chriso   ep4gb8cpuAThwwo2k     465788  --- 5120000 3000000 R  
        # 423.w0009024.pcd.daimler-benz.com FD75sk8 chriso   ep4gb8cpuAThwwo2k           999 8192000 12000000 Qgm
        #


        # There can be many TSIs running, return about all Jobs

        $result = "QSTAT\n";
        $_ = $output;

        # Note g to resume from end of last match

        while(/^(\d+)\..* (\S)\S*\s*$/gm) {

	     $bssid = $1;
             $state = $2;

	     # Catches all known values.
	     # Absent statuses are treated as unknown as status will contain a number
	     $ustate = "UNKNOWN";

             #        A - arriving, queue has not processed, so not running
             #        D - departing, leaving pipe so not running
             #        Q -  job is queued, eligable to run or routed.
             #        W -  job is waiting for its execution time
             #             (-a option) to be reached.
	     $ustate = "QUEUED"  if $state =~ /A|D|Q|W/;

             #        E -  Job is exiting after having run.
             #        R -  job is running.
             $ustate = "RUNNING" if $state =~ /R|E/ ;

             #        C - checkpointed ?
             #        H - held
             #        P - preempted, assume that it will be automatically restarted
             #        S - suspended
             $ustate = "SUSPENDED" if $state =~ /C|H|P|S/ ;

         # can also report FROZEN if this is supported by BSS (held and resources released)

	     # Add to the returned lines
	     $result = "$result $bssid $ustate\n";

	}

        print main::CMD_SOCK $result;
        debug_report("qstat executed OK");
    }
}
#
#                   Copyright (c) Fujitsu Ltd 2000 - 2004
#
#                Use and distribution is subject a License.
# A copy was supplied with the distribution (see documentation or the jar file).
#
# This product includes software developed by Fujitsu Limited (http://www.fujitsu.com).
